package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class PaymentInfo {
  private List<Payment> payments;

  private List<Reference> paymentRefs;

  public PaymentInfo() {
  }

  public PaymentInfo(List<Payment> payments, List<Reference> paymentRefs) {
    this.payments = payments;
    this.paymentRefs = paymentRefs;
  }

  public List<Payment> getPayments() {
    return payments;
  }

  public void setPayments(List<Payment> payments) {
    this.payments = payments;
  }

  public List<Reference> getPaymentRefs() {
    return paymentRefs;
  }

  public void setPaymentRefs(List<Reference> paymentRefs) {
    this.paymentRefs = paymentRefs;
  }

  @Override
  public String toString() {
    return "PaymentInfo{payments='" + payments + "', paymentRefs='" + paymentRefs + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentInfo that = (PaymentInfo) o;
    return Objects.equals(payments, that.payments) &&
        Objects.equals(paymentRefs, that.paymentRefs);
  }

  @Override
  public int hashCode() {
    return Objects.hash(payments, paymentRefs);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<Payment> payments;

    private List<Reference> paymentRefs;

    public PaymentInfo build() {
      PaymentInfo result = new PaymentInfo();
      result.payments = this.payments;
      result.paymentRefs = this.paymentRefs;
      return result;
    }

    public Builder payments(List<Payment> payments) {
      this.payments = payments;
      return this;
    }

    public Builder paymentRefs(List<Reference> paymentRefs) {
      this.paymentRefs = paymentRefs;
      return this;
    }
  }
}
