package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PaymentInteractionAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private CustomFieldsType interaction;

  private String type;

  public PaymentInteractionAdded() {
  }

  public PaymentInteractionAdded(CustomFieldsType interaction, String type) {
    this.interaction = interaction;
    this.type = type;
  }

  public CustomFieldsType getInteraction() {
    return interaction;
  }

  public void setInteraction(CustomFieldsType interaction) {
    this.interaction = interaction;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "PaymentInteractionAdded{interaction='" + interaction + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentInteractionAdded that = (PaymentInteractionAdded) o;
    return Objects.equals(interaction, that.interaction) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(interaction, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private CustomFieldsType interaction;

    private String type;

    public PaymentInteractionAdded build() {
      PaymentInteractionAdded result = new PaymentInteractionAdded();
      result.interaction = this.interaction;
      result.type = this.type;
      return result;
    }

    public Builder interaction(CustomFieldsType interaction) {
      this.interaction = interaction;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
