package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PaymentStatusInterfaceCodeSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String paymentId;

  private String interfaceCode;

  private String type;

  public PaymentStatusInterfaceCodeSet() {
  }

  public PaymentStatusInterfaceCodeSet(String paymentId, String interfaceCode, String type) {
    this.paymentId = paymentId;
    this.interfaceCode = interfaceCode;
    this.type = type;
  }

  public String getPaymentId() {
    return paymentId;
  }

  public void setPaymentId(String paymentId) {
    this.paymentId = paymentId;
  }

  public String getInterfaceCode() {
    return interfaceCode;
  }

  public void setInterfaceCode(String interfaceCode) {
    this.interfaceCode = interfaceCode;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "PaymentStatusInterfaceCodeSet{paymentId='" + paymentId + "', interfaceCode='" + interfaceCode + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentStatusInterfaceCodeSet that = (PaymentStatusInterfaceCodeSet) o;
    return Objects.equals(paymentId, that.paymentId) &&
        Objects.equals(interfaceCode, that.interfaceCode) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(paymentId, interfaceCode, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String paymentId;

    private String interfaceCode;

    private String type;

    public PaymentStatusInterfaceCodeSet build() {
      PaymentStatusInterfaceCodeSet result = new PaymentStatusInterfaceCodeSet();
      result.paymentId = this.paymentId;
      result.interfaceCode = this.interfaceCode;
      result.type = this.type;
      return result;
    }

    public Builder paymentId(String paymentId) {
      this.paymentId = paymentId;
      return this;
    }

    public Builder interfaceCode(String interfaceCode) {
      this.interfaceCode = interfaceCode;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
