package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PaymentTransactionAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private Transaction transaction;

  private String type;

  public PaymentTransactionAdded() {
  }

  public PaymentTransactionAdded(Transaction transaction, String type) {
    this.transaction = transaction;
    this.type = type;
  }

  public Transaction getTransaction() {
    return transaction;
  }

  public void setTransaction(Transaction transaction) {
    this.transaction = transaction;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "PaymentTransactionAdded{transaction='" + transaction + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentTransactionAdded that = (PaymentTransactionAdded) o;
    return Objects.equals(transaction, that.transaction) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transaction, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Transaction transaction;

    private String type;

    public PaymentTransactionAdded build() {
      PaymentTransactionAdded result = new PaymentTransactionAdded();
      result.transaction = this.transaction;
      result.type = this.type;
      return result;
    }

    public Builder transaction(Transaction transaction) {
      this.transaction = transaction;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
