package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PaymentTransactionStateChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private String transactionId;

  private TransactionState state;

  private String type;

  public PaymentTransactionStateChanged() {
  }

  public PaymentTransactionStateChanged(String transactionId, TransactionState state, String type) {
    this.transactionId = transactionId;
    this.state = state;
    this.type = type;
  }

  public String getTransactionId() {
    return transactionId;
  }

  public void setTransactionId(String transactionId) {
    this.transactionId = transactionId;
  }

  public TransactionState getState() {
    return state;
  }

  public void setState(TransactionState state) {
    this.state = state;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "PaymentTransactionStateChanged{transactionId='" + transactionId + "', state='" + state + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PaymentTransactionStateChanged that = (PaymentTransactionStateChanged) o;
    return Objects.equals(transactionId, that.transactionId) &&
        Objects.equals(state, that.state) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(transactionId, state, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String transactionId;

    private TransactionState state;

    private String type;

    public PaymentTransactionStateChanged build() {
      PaymentTransactionStateChanged result = new PaymentTransactionStateChanged();
      result.transactionId = this.transactionId;
      result.state = this.state;
      result.type = this.type;
      return result;
    }

    public Builder transactionId(String transactionId) {
      this.transactionId = transactionId;
      return this;
    }

    public Builder state(TransactionState state) {
      this.state = state;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
