package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class PlainEnumValueDraft {
  private String key;

  private String label;

  public PlainEnumValueDraft() {
  }

  public PlainEnumValueDraft(String key, String label) {
    this.key = key;
    this.label = label;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getLabel() {
    return label;
  }

  public void setLabel(String label) {
    this.label = label;
  }

  @Override
  public String toString() {
    return "PlainEnumValueDraft{key='" + key + "', label='" + label + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlainEnumValueDraft that = (PlainEnumValueDraft) o;
    return Objects.equals(key, that.key) &&
        Objects.equals(label, that.label);
  }

  @Override
  public int hashCode() {
    return Objects.hash(key, label);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String key;

    private String label;

    public PlainEnumValueDraft build() {
      PlainEnumValueDraft result = new PlainEnumValueDraft();
      result.key = this.key;
      result.label = this.label;
      return result;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder label(String label) {
      this.label = label;
      return this;
    }
  }
}
