package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PreviewFailure implements com.commercetools.graphql.api.types.OrderEditResult {
  private String type;

  private List<JsonNode> errors;

  public PreviewFailure() {
  }

  public PreviewFailure(String type, List<JsonNode> errors) {
    this.type = type;
    this.errors = errors;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<JsonNode> getErrors() {
    return errors;
  }

  public void setErrors(List<JsonNode> errors) {
    this.errors = errors;
  }

  @Override
  public String toString() {
    return "PreviewFailure{type='" + type + "', errors='" + errors + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreviewFailure that = (PreviewFailure) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(errors, that.errors);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, errors);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private List<JsonNode> errors;

    public PreviewFailure build() {
      PreviewFailure result = new PreviewFailure();
      result.type = this.type;
      result.errors = this.errors;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder errors(List<JsonNode> errors) {
      this.errors = errors;
      return this;
    }
  }
}
