package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class PreviewSuccess implements com.commercetools.graphql.api.types.OrderEditResult {
  private String type;

  private Order preview;

  private List<OrderMessagePayload> messagePayloads;

  public PreviewSuccess() {
  }

  public PreviewSuccess(String type, Order preview, List<OrderMessagePayload> messagePayloads) {
    this.type = type;
    this.preview = preview;
    this.messagePayloads = messagePayloads;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Order getPreview() {
    return preview;
  }

  public void setPreview(Order preview) {
    this.preview = preview;
  }

  public List<OrderMessagePayload> getMessagePayloads() {
    return messagePayloads;
  }

  public void setMessagePayloads(List<OrderMessagePayload> messagePayloads) {
    this.messagePayloads = messagePayloads;
  }

  @Override
  public String toString() {
    return "PreviewSuccess{type='" + type + "', preview='" + preview + "', messagePayloads='" + messagePayloads + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PreviewSuccess that = (PreviewSuccess) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(preview, that.preview) &&
        Objects.equals(messagePayloads, that.messagePayloads);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, preview, messagePayloads);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private Order preview;

    private List<OrderMessagePayload> messagePayloads;

    public PreviewSuccess build() {
      PreviewSuccess result = new PreviewSuccess();
      result.type = this.type;
      result.preview = this.preview;
      result.messagePayloads = this.messagePayloads;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder preview(Order preview) {
      this.preview = preview;
      return this;
    }

    public Builder messagePayloads(List<OrderMessagePayload> messagePayloads) {
      this.messagePayloads = messagePayloads;
      return this;
    }
  }
}
