package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductAssignment {
  private Reference productRef;

  private Product product;

  private Reference productSelectionRef;

  private ProductSelection productSelection;

  private ProductVariantSelection variantSelection;

  private ProductVariantExclusion variantExclusion;

  public ProductAssignment() {
  }

  public ProductAssignment(Reference productRef, Product product, Reference productSelectionRef,
      ProductSelection productSelection, ProductVariantSelection variantSelection,
      ProductVariantExclusion variantExclusion) {
    this.productRef = productRef;
    this.product = product;
    this.productSelectionRef = productSelectionRef;
    this.productSelection = productSelection;
    this.variantSelection = variantSelection;
    this.variantExclusion = variantExclusion;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public Reference getProductSelectionRef() {
    return productSelectionRef;
  }

  public void setProductSelectionRef(Reference productSelectionRef) {
    this.productSelectionRef = productSelectionRef;
  }

  public ProductSelection getProductSelection() {
    return productSelection;
  }

  public void setProductSelection(ProductSelection productSelection) {
    this.productSelection = productSelection;
  }

  public ProductVariantSelection getVariantSelection() {
    return variantSelection;
  }

  public void setVariantSelection(ProductVariantSelection variantSelection) {
    this.variantSelection = variantSelection;
  }

  public ProductVariantExclusion getVariantExclusion() {
    return variantExclusion;
  }

  public void setVariantExclusion(ProductVariantExclusion variantExclusion) {
    this.variantExclusion = variantExclusion;
  }

  @Override
  public String toString() {
    return "ProductAssignment{productRef='" + productRef + "', product='" + product + "', productSelectionRef='" + productSelectionRef + "', productSelection='" + productSelection + "', variantSelection='" + variantSelection + "', variantExclusion='" + variantExclusion + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductAssignment that = (ProductAssignment) o;
    return Objects.equals(productRef, that.productRef) &&
        Objects.equals(product, that.product) &&
        Objects.equals(productSelectionRef, that.productSelectionRef) &&
        Objects.equals(productSelection, that.productSelection) &&
        Objects.equals(variantSelection, that.variantSelection) &&
        Objects.equals(variantExclusion, that.variantExclusion);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productRef, product, productSelectionRef, productSelection, variantSelection, variantExclusion);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference productRef;

    private Product product;

    private Reference productSelectionRef;

    private ProductSelection productSelection;

    private ProductVariantSelection variantSelection;

    private ProductVariantExclusion variantExclusion;

    public ProductAssignment build() {
      ProductAssignment result = new ProductAssignment();
      result.productRef = this.productRef;
      result.product = this.product;
      result.productSelectionRef = this.productSelectionRef;
      result.productSelection = this.productSelection;
      result.variantSelection = this.variantSelection;
      result.variantExclusion = this.variantExclusion;
      return result;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder productSelectionRef(Reference productSelectionRef) {
      this.productSelectionRef = productSelectionRef;
      return this;
    }

    public Builder productSelection(ProductSelection productSelection) {
      this.productSelection = productSelection;
      return this;
    }

    public Builder variantSelection(ProductVariantSelection variantSelection) {
      this.variantSelection = variantSelection;
      return this;
    }

    public Builder variantExclusion(ProductVariantExclusion variantExclusion) {
      this.variantExclusion = variantExclusion;
      return this;
    }
  }
}
