package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductCatalogData {
  private ProductData current;

  private ProductData staged;

  private Boolean published;

  private Boolean hasStagedChanges;

  public ProductCatalogData() {
  }

  public ProductCatalogData(ProductData current, ProductData staged, Boolean published,
      Boolean hasStagedChanges) {
    this.current = current;
    this.staged = staged;
    this.published = published;
    this.hasStagedChanges = hasStagedChanges;
  }

  public ProductData getCurrent() {
    return current;
  }

  public void setCurrent(ProductData current) {
    this.current = current;
  }

  public ProductData getStaged() {
    return staged;
  }

  public void setStaged(ProductData staged) {
    this.staged = staged;
  }

  public Boolean getPublished() {
    return published;
  }

  public void setPublished(Boolean published) {
    this.published = published;
  }

  public Boolean getHasStagedChanges() {
    return hasStagedChanges;
  }

  public void setHasStagedChanges(Boolean hasStagedChanges) {
    this.hasStagedChanges = hasStagedChanges;
  }

  @Override
  public String toString() {
    return "ProductCatalogData{current='" + current + "', staged='" + staged + "', published='" + published + "', hasStagedChanges='" + hasStagedChanges + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductCatalogData that = (ProductCatalogData) o;
    return Objects.equals(current, that.current) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(published, that.published) &&
        Objects.equals(hasStagedChanges, that.hasStagedChanges);
  }

  @Override
  public int hashCode() {
    return Objects.hash(current, staged, published, hasStagedChanges);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductData current;

    private ProductData staged;

    private Boolean published;

    private Boolean hasStagedChanges;

    public ProductCatalogData build() {
      ProductCatalogData result = new ProductCatalogData();
      result.current = this.current;
      result.staged = this.staged;
      result.published = this.published;
      result.hasStagedChanges = this.hasStagedChanges;
      return result;
    }

    public Builder current(ProductData current) {
      this.current = current;
      return this;
    }

    public Builder staged(ProductData staged) {
      this.staged = staged;
      return this;
    }

    public Builder published(Boolean published) {
      this.published = published;
      return this;
    }

    public Builder hasStagedChanges(Boolean hasStagedChanges) {
      this.hasStagedChanges = hasStagedChanges;
      return this;
    }
  }
}
