package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductProjectionMessagePayload productProjection;

  private String type;

  public ProductCreated() {
  }

  public ProductCreated(ProductProjectionMessagePayload productProjection, String type) {
    this.productProjection = productProjection;
    this.type = type;
  }

  public ProductProjectionMessagePayload getProductProjection() {
    return productProjection;
  }

  public void setProductProjection(ProductProjectionMessagePayload productProjection) {
    this.productProjection = productProjection;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductCreated{productProjection='" + productProjection + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductCreated that = (ProductCreated) o;
    return Objects.equals(productProjection, that.productProjection) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productProjection, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductProjectionMessagePayload productProjection;

    private String type;

    public ProductCreated build() {
      ProductCreated result = new ProductCreated();
      result.productProjection = this.productProjection;
      result.type = this.type;
      return result;
    }

    public Builder productProjection(ProductProjectionMessagePayload productProjection) {
      this.productProjection = productProjection;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
