package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class ProductDiscountDraft {
  private ProductDiscountValueInput value;

  private String predicate;

  private String sortOrder;

  private List<LocalizedStringItemInputType> name;

  private List<LocalizedStringItemInputType> description;

  private OffsetDateTime validFrom;

  private OffsetDateTime validUntil;

  private Boolean isActive = true;

  private String key;

  public ProductDiscountDraft() {
  }

  public ProductDiscountDraft(ProductDiscountValueInput value, String predicate, String sortOrder,
      List<LocalizedStringItemInputType> name, List<LocalizedStringItemInputType> description,
      OffsetDateTime validFrom, OffsetDateTime validUntil, Boolean isActive, String key) {
    this.value = value;
    this.predicate = predicate;
    this.sortOrder = sortOrder;
    this.name = name;
    this.description = description;
    this.validFrom = validFrom;
    this.validUntil = validUntil;
    this.isActive = isActive;
    this.key = key;
  }

  public ProductDiscountValueInput getValue() {
    return value;
  }

  public void setValue(ProductDiscountValueInput value) {
    this.value = value;
  }

  public String getPredicate() {
    return predicate;
  }

  public void setPredicate(String predicate) {
    this.predicate = predicate;
  }

  public String getSortOrder() {
    return sortOrder;
  }

  public void setSortOrder(String sortOrder) {
    this.sortOrder = sortOrder;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public OffsetDateTime getValidFrom() {
    return validFrom;
  }

  public void setValidFrom(OffsetDateTime validFrom) {
    this.validFrom = validFrom;
  }

  public OffsetDateTime getValidUntil() {
    return validUntil;
  }

  public void setValidUntil(OffsetDateTime validUntil) {
    this.validUntil = validUntil;
  }

  public Boolean getIsActive() {
    return isActive;
  }

  public void setIsActive(Boolean isActive) {
    this.isActive = isActive;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  @Override
  public String toString() {
    return "ProductDiscountDraft{value='" + value + "', predicate='" + predicate + "', sortOrder='" + sortOrder + "', name='" + name + "', description='" + description + "', validFrom='" + validFrom + "', validUntil='" + validUntil + "', isActive='" + isActive + "', key='" + key + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductDiscountDraft that = (ProductDiscountDraft) o;
    return Objects.equals(value, that.value) &&
        Objects.equals(predicate, that.predicate) &&
        Objects.equals(sortOrder, that.sortOrder) &&
        Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(validFrom, that.validFrom) &&
        Objects.equals(validUntil, that.validUntil) &&
        Objects.equals(isActive, that.isActive) &&
        Objects.equals(key, that.key);
  }

  @Override
  public int hashCode() {
    return Objects.hash(value, predicate, sortOrder, name, description, validFrom, validUntil, isActive, key);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductDiscountValueInput value;

    private String predicate;

    private String sortOrder;

    private List<LocalizedStringItemInputType> name;

    private List<LocalizedStringItemInputType> description;

    private OffsetDateTime validFrom;

    private OffsetDateTime validUntil;

    private Boolean isActive = true;

    private String key;

    public ProductDiscountDraft build() {
      ProductDiscountDraft result = new ProductDiscountDraft();
      result.value = this.value;
      result.predicate = this.predicate;
      result.sortOrder = this.sortOrder;
      result.name = this.name;
      result.description = this.description;
      result.validFrom = this.validFrom;
      result.validUntil = this.validUntil;
      result.isActive = this.isActive;
      result.key = this.key;
      return result;
    }

    public Builder value(ProductDiscountValueInput value) {
      this.value = value;
      return this;
    }

    public Builder predicate(String predicate) {
      this.predicate = predicate;
      return this;
    }

    public Builder sortOrder(String sortOrder) {
      this.sortOrder = sortOrder;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder validFrom(OffsetDateTime validFrom) {
      this.validFrom = validFrom;
      return this;
    }

    public Builder validUntil(OffsetDateTime validUntil) {
      this.validUntil = validUntil;
      return this;
    }

    public Builder isActive(Boolean isActive) {
      this.isActive = isActive;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }
  }
}
