package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductDraft {
  private List<LocalizedStringItemInputType> name;

  private ResourceIdentifierInput productType;

  private List<LocalizedStringItemInputType> slug;

  private String key;

  private List<LocalizedStringItemInputType> description;

  private List<ResourceIdentifierInput> categories;

  private List<CategoryOrderHintInput> categoryOrderHints;

  private List<LocalizedStringItemInputType> metaTitle;

  private List<LocalizedStringItemInputType> metaDescription;

  private List<LocalizedStringItemInputType> metaKeywords;

  private ProductVariantInput masterVariant;

  private List<ProductVariantInput> variants = Collections.emptyList();

  private ResourceIdentifierInput taxCategory;

  private ResourceIdentifierInput state;

  private PriceMode priceMode;

  private List<SearchKeywordInput> searchKeywords;

  private Boolean publish;

  public ProductDraft() {
  }

  public ProductDraft(List<LocalizedStringItemInputType> name, ResourceIdentifierInput productType,
      List<LocalizedStringItemInputType> slug, String key,
      List<LocalizedStringItemInputType> description, List<ResourceIdentifierInput> categories,
      List<CategoryOrderHintInput> categoryOrderHints, List<LocalizedStringItemInputType> metaTitle,
      List<LocalizedStringItemInputType> metaDescription,
      List<LocalizedStringItemInputType> metaKeywords, ProductVariantInput masterVariant,
      List<ProductVariantInput> variants, ResourceIdentifierInput taxCategory,
      ResourceIdentifierInput state, PriceMode priceMode, List<SearchKeywordInput> searchKeywords,
      Boolean publish) {
    this.name = name;
    this.productType = productType;
    this.slug = slug;
    this.key = key;
    this.description = description;
    this.categories = categories;
    this.categoryOrderHints = categoryOrderHints;
    this.metaTitle = metaTitle;
    this.metaDescription = metaDescription;
    this.metaKeywords = metaKeywords;
    this.masterVariant = masterVariant;
    this.variants = variants;
    this.taxCategory = taxCategory;
    this.state = state;
    this.priceMode = priceMode;
    this.searchKeywords = searchKeywords;
    this.publish = publish;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public ResourceIdentifierInput getProductType() {
    return productType;
  }

  public void setProductType(ResourceIdentifierInput productType) {
    this.productType = productType;
  }

  public List<LocalizedStringItemInputType> getSlug() {
    return slug;
  }

  public void setSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<ResourceIdentifierInput> getCategories() {
    return categories;
  }

  public void setCategories(List<ResourceIdentifierInput> categories) {
    this.categories = categories;
  }

  public List<CategoryOrderHintInput> getCategoryOrderHints() {
    return categoryOrderHints;
  }

  public void setCategoryOrderHints(List<CategoryOrderHintInput> categoryOrderHints) {
    this.categoryOrderHints = categoryOrderHints;
  }

  public List<LocalizedStringItemInputType> getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedStringItemInputType> getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(List<LocalizedStringItemInputType> metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedStringItemInputType> getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public ProductVariantInput getMasterVariant() {
    return masterVariant;
  }

  public void setMasterVariant(ProductVariantInput masterVariant) {
    this.masterVariant = masterVariant;
  }

  public List<ProductVariantInput> getVariants() {
    return variants;
  }

  public void setVariants(List<ProductVariantInput> variants) {
    this.variants = variants;
  }

  public ResourceIdentifierInput getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(ResourceIdentifierInput taxCategory) {
    this.taxCategory = taxCategory;
  }

  public ResourceIdentifierInput getState() {
    return state;
  }

  public void setState(ResourceIdentifierInput state) {
    this.state = state;
  }

  public PriceMode getPriceMode() {
    return priceMode;
  }

  public void setPriceMode(PriceMode priceMode) {
    this.priceMode = priceMode;
  }

  public List<SearchKeywordInput> getSearchKeywords() {
    return searchKeywords;
  }

  public void setSearchKeywords(List<SearchKeywordInput> searchKeywords) {
    this.searchKeywords = searchKeywords;
  }

  public Boolean getPublish() {
    return publish;
  }

  public void setPublish(Boolean publish) {
    this.publish = publish;
  }

  @Override
  public String toString() {
    return "ProductDraft{name='" + name + "', productType='" + productType + "', slug='" + slug + "', key='" + key + "', description='" + description + "', categories='" + categories + "', categoryOrderHints='" + categoryOrderHints + "', metaTitle='" + metaTitle + "', metaDescription='" + metaDescription + "', metaKeywords='" + metaKeywords + "', masterVariant='" + masterVariant + "', variants='" + variants + "', taxCategory='" + taxCategory + "', state='" + state + "', priceMode='" + priceMode + "', searchKeywords='" + searchKeywords + "', publish='" + publish + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductDraft that = (ProductDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(productType, that.productType) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(key, that.key) &&
        Objects.equals(description, that.description) &&
        Objects.equals(categories, that.categories) &&
        Objects.equals(categoryOrderHints, that.categoryOrderHints) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(masterVariant, that.masterVariant) &&
        Objects.equals(variants, that.variants) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(state, that.state) &&
        Objects.equals(priceMode, that.priceMode) &&
        Objects.equals(searchKeywords, that.searchKeywords) &&
        Objects.equals(publish, that.publish);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, productType, slug, key, description, categories, categoryOrderHints, metaTitle, metaDescription, metaKeywords, masterVariant, variants, taxCategory, state, priceMode, searchKeywords, publish);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<LocalizedStringItemInputType> name;

    private ResourceIdentifierInput productType;

    private List<LocalizedStringItemInputType> slug;

    private String key;

    private List<LocalizedStringItemInputType> description;

    private List<ResourceIdentifierInput> categories;

    private List<CategoryOrderHintInput> categoryOrderHints;

    private List<LocalizedStringItemInputType> metaTitle;

    private List<LocalizedStringItemInputType> metaDescription;

    private List<LocalizedStringItemInputType> metaKeywords;

    private ProductVariantInput masterVariant;

    private List<ProductVariantInput> variants = Collections.emptyList();

    private ResourceIdentifierInput taxCategory;

    private ResourceIdentifierInput state;

    private PriceMode priceMode;

    private List<SearchKeywordInput> searchKeywords;

    private Boolean publish;

    public ProductDraft build() {
      ProductDraft result = new ProductDraft();
      result.name = this.name;
      result.productType = this.productType;
      result.slug = this.slug;
      result.key = this.key;
      result.description = this.description;
      result.categories = this.categories;
      result.categoryOrderHints = this.categoryOrderHints;
      result.metaTitle = this.metaTitle;
      result.metaDescription = this.metaDescription;
      result.metaKeywords = this.metaKeywords;
      result.masterVariant = this.masterVariant;
      result.variants = this.variants;
      result.taxCategory = this.taxCategory;
      result.state = this.state;
      result.priceMode = this.priceMode;
      result.searchKeywords = this.searchKeywords;
      result.publish = this.publish;
      return result;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder productType(ResourceIdentifierInput productType) {
      this.productType = productType;
      return this;
    }

    public Builder slug(List<LocalizedStringItemInputType> slug) {
      this.slug = slug;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder categories(List<ResourceIdentifierInput> categories) {
      this.categories = categories;
      return this;
    }

    public Builder categoryOrderHints(List<CategoryOrderHintInput> categoryOrderHints) {
      this.categoryOrderHints = categoryOrderHints;
      return this;
    }

    public Builder metaTitle(List<LocalizedStringItemInputType> metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder metaDescription(List<LocalizedStringItemInputType> metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder masterVariant(ProductVariantInput masterVariant) {
      this.masterVariant = masterVariant;
      return this;
    }

    public Builder variants(List<ProductVariantInput> variants) {
      this.variants = variants;
      return this;
    }

    public Builder taxCategory(ResourceIdentifierInput taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder state(ResourceIdentifierInput state) {
      this.state = state;
      return this;
    }

    public Builder priceMode(PriceMode priceMode) {
      this.priceMode = priceMode;
      return this;
    }

    public Builder searchKeywords(List<SearchKeywordInput> searchKeywords) {
      this.searchKeywords = searchKeywords;
      return this;
    }

    public Builder publish(Boolean publish) {
      this.publish = publish;
      return this;
    }
  }
}
