package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductImageAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private Image image;

  private Boolean staged;

  private String type;

  public ProductImageAdded() {
  }

  public ProductImageAdded(Integer variantId, Image image, Boolean staged, String type) {
    this.variantId = variantId;
    this.image = image;
    this.staged = staged;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public Image getImage() {
    return image;
  }

  public void setImage(Image image) {
    this.image = image;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductImageAdded{variantId='" + variantId + "', image='" + image + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductImageAdded that = (ProductImageAdded) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(image, that.image) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, image, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private Image image;

    private Boolean staged;

    private String type;

    public ProductImageAdded build() {
      ProductImageAdded result = new ProductImageAdded();
      result.variantId = this.variantId;
      result.image = this.image;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder image(Image image) {
      this.image = image;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
