package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private ProductPrice oldPrice;

  private ProductPrice newPrice;

  private Boolean staged;

  private ProductPrice oldStagedPrice;

  private String type;

  public ProductPriceChanged() {
  }

  public ProductPriceChanged(Integer variantId, ProductPrice oldPrice, ProductPrice newPrice,
      Boolean staged, ProductPrice oldStagedPrice, String type) {
    this.variantId = variantId;
    this.oldPrice = oldPrice;
    this.newPrice = newPrice;
    this.staged = staged;
    this.oldStagedPrice = oldStagedPrice;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public ProductPrice getOldPrice() {
    return oldPrice;
  }

  public void setOldPrice(ProductPrice oldPrice) {
    this.oldPrice = oldPrice;
  }

  public ProductPrice getNewPrice() {
    return newPrice;
  }

  public void setNewPrice(ProductPrice newPrice) {
    this.newPrice = newPrice;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public ProductPrice getOldStagedPrice() {
    return oldStagedPrice;
  }

  public void setOldStagedPrice(ProductPrice oldStagedPrice) {
    this.oldStagedPrice = oldStagedPrice;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceChanged{variantId='" + variantId + "', oldPrice='" + oldPrice + "', newPrice='" + newPrice + "', staged='" + staged + "', oldStagedPrice='" + oldStagedPrice + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceChanged that = (ProductPriceChanged) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(oldPrice, that.oldPrice) &&
        Objects.equals(newPrice, that.newPrice) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(oldStagedPrice, that.oldStagedPrice) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, oldPrice, newPrice, staged, oldStagedPrice, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private ProductPrice oldPrice;

    private ProductPrice newPrice;

    private Boolean staged;

    private ProductPrice oldStagedPrice;

    private String type;

    public ProductPriceChanged build() {
      ProductPriceChanged result = new ProductPriceChanged();
      result.variantId = this.variantId;
      result.oldPrice = this.oldPrice;
      result.newPrice = this.newPrice;
      result.staged = this.staged;
      result.oldStagedPrice = this.oldStagedPrice;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder oldPrice(ProductPrice oldPrice) {
      this.oldPrice = oldPrice;
      return this;
    }

    public Builder newPrice(ProductPrice newPrice) {
      this.newPrice = newPrice;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder oldStagedPrice(ProductPrice oldStagedPrice) {
      this.oldStagedPrice = oldStagedPrice;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
