package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.JsonNode;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceCustomFieldAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private String priceId;

  private Integer variantId;

  private Boolean staged;

  private String name;

  private JsonNode value;

  private String type;

  public ProductPriceCustomFieldAdded() {
  }

  public ProductPriceCustomFieldAdded(String priceId, Integer variantId, Boolean staged,
      String name, JsonNode value, String type) {
    this.priceId = priceId;
    this.variantId = variantId;
    this.staged = staged;
    this.name = name;
    this.value = value;
    this.type = type;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public JsonNode getValue() {
    return value;
  }

  public void setValue(JsonNode value) {
    this.value = value;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceCustomFieldAdded{priceId='" + priceId + "', variantId='" + variantId + "', staged='" + staged + "', name='" + name + "', value='" + value + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceCustomFieldAdded that = (ProductPriceCustomFieldAdded) o;
    return Objects.equals(priceId, that.priceId) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(name, that.name) &&
        Objects.equals(value, that.value) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceId, variantId, staged, name, value, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String priceId;

    private Integer variantId;

    private Boolean staged;

    private String name;

    private JsonNode value;

    private String type;

    public ProductPriceCustomFieldAdded build() {
      ProductPriceCustomFieldAdded result = new ProductPriceCustomFieldAdded();
      result.priceId = this.priceId;
      result.variantId = this.variantId;
      result.staged = this.staged;
      result.name = this.name;
      result.value = this.value;
      result.type = this.type;
      return result;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder value(JsonNode value) {
      this.value = value;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
