package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceCustomFieldsSet implements com.commercetools.graphql.api.types.MessagePayload {
  private String priceId;

  private Integer variantId;

  private Boolean staged;

  private CustomFieldsType customField;

  private String oldTypeId;

  private String type;

  public ProductPriceCustomFieldsSet() {
  }

  public ProductPriceCustomFieldsSet(String priceId, Integer variantId, Boolean staged,
      CustomFieldsType customField, String oldTypeId, String type) {
    this.priceId = priceId;
    this.variantId = variantId;
    this.staged = staged;
    this.customField = customField;
    this.oldTypeId = oldTypeId;
    this.type = type;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public CustomFieldsType getCustomField() {
    return customField;
  }

  public void setCustomField(CustomFieldsType customField) {
    this.customField = customField;
  }

  public String getOldTypeId() {
    return oldTypeId;
  }

  public void setOldTypeId(String oldTypeId) {
    this.oldTypeId = oldTypeId;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceCustomFieldsSet{priceId='" + priceId + "', variantId='" + variantId + "', staged='" + staged + "', customField='" + customField + "', oldTypeId='" + oldTypeId + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceCustomFieldsSet that = (ProductPriceCustomFieldsSet) o;
    return Objects.equals(priceId, that.priceId) &&
        Objects.equals(variantId, that.variantId) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(customField, that.customField) &&
        Objects.equals(oldTypeId, that.oldTypeId) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(priceId, variantId, staged, customField, oldTypeId, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String priceId;

    private Integer variantId;

    private Boolean staged;

    private CustomFieldsType customField;

    private String oldTypeId;

    private String type;

    public ProductPriceCustomFieldsSet build() {
      ProductPriceCustomFieldsSet result = new ProductPriceCustomFieldsSet();
      result.priceId = this.priceId;
      result.variantId = this.variantId;
      result.staged = this.staged;
      result.customField = this.customField;
      result.oldTypeId = this.oldTypeId;
      result.type = this.type;
      return result;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder customField(CustomFieldsType customField) {
      this.customField = customField;
      return this;
    }

    public Builder oldTypeId(String oldTypeId) {
      this.oldTypeId = oldTypeId;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
