package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductPriceDiscountUpdateMessagePayload {
  private Integer variantId;

  private String variantKey;

  private String sku;

  private String priceId;

  private DiscountedProductPriceValue discounted;

  private Boolean staged;

  public ProductPriceDiscountUpdateMessagePayload() {
  }

  public ProductPriceDiscountUpdateMessagePayload(Integer variantId, String variantKey, String sku,
      String priceId, DiscountedProductPriceValue discounted, Boolean staged) {
    this.variantId = variantId;
    this.variantKey = variantKey;
    this.sku = sku;
    this.priceId = priceId;
    this.discounted = discounted;
    this.staged = staged;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public String getVariantKey() {
    return variantKey;
  }

  public void setVariantKey(String variantKey) {
    this.variantKey = variantKey;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getPriceId() {
    return priceId;
  }

  public void setPriceId(String priceId) {
    this.priceId = priceId;
  }

  public DiscountedProductPriceValue getDiscounted() {
    return discounted;
  }

  public void setDiscounted(DiscountedProductPriceValue discounted) {
    this.discounted = discounted;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  @Override
  public String toString() {
    return "ProductPriceDiscountUpdateMessagePayload{variantId='" + variantId + "', variantKey='" + variantKey + "', sku='" + sku + "', priceId='" + priceId + "', discounted='" + discounted + "', staged='" + staged + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceDiscountUpdateMessagePayload that = (ProductPriceDiscountUpdateMessagePayload) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(variantKey, that.variantKey) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(priceId, that.priceId) &&
        Objects.equals(discounted, that.discounted) &&
        Objects.equals(staged, that.staged);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, variantKey, sku, priceId, discounted, staged);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private String variantKey;

    private String sku;

    private String priceId;

    private DiscountedProductPriceValue discounted;

    private Boolean staged;

    public ProductPriceDiscountUpdateMessagePayload build() {
      ProductPriceDiscountUpdateMessagePayload result = new ProductPriceDiscountUpdateMessagePayload();
      result.variantId = this.variantId;
      result.variantKey = this.variantKey;
      result.sku = this.sku;
      result.priceId = this.priceId;
      result.discounted = this.discounted;
      result.staged = this.staged;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder variantKey(String variantKey) {
      this.variantKey = variantKey;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder priceId(String priceId) {
      this.priceId = priceId;
      return this;
    }

    public Builder discounted(DiscountedProductPriceValue discounted) {
      this.discounted = discounted;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }
  }
}
