package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPriceModeSet implements com.commercetools.graphql.api.types.MessagePayload {
  private PriceMode to;

  private String type;

  public ProductPriceModeSet() {
  }

  public ProductPriceModeSet(PriceMode to, String type) {
    this.to = to;
    this.type = type;
  }

  public PriceMode getTo() {
    return to;
  }

  public void setTo(PriceMode to) {
    this.to = to;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPriceModeSet{to='" + to + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPriceModeSet that = (ProductPriceModeSet) o;
    return Objects.equals(to, that.to) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(to, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private PriceMode to;

    private String type;

    public ProductPriceModeSet build() {
      ProductPriceModeSet result = new ProductPriceModeSet();
      result.to = this.to;
      result.type = this.type;
      return result;
    }

    public Builder to(PriceMode to) {
      this.to = to;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
