package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;

public class ProductProjectionMessagePayload {
  private String id;

  private Long version;

  private OffsetDateTime createdAt;

  private OffsetDateTime lastModifiedAt;

  private Reference productTypeRef;

  private ProductTypeDefinition productType;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private String description;

  private List<LocalizedString> descriptionAllLocales;

  private String slug;

  private List<LocalizedString> slugAllLocales;

  private List<CategoryOrderHint> categoryOrderHints;

  private List<Reference> categoriesRef;

  private List<Category> categories;

  private List<SearchKeywords> searchKeywords;

  private String metaTitle;

  private List<LocalizedString> metaTitleAllLocales;

  private String metaKeywords;

  private List<LocalizedString> metaKeywordsAllLocales;

  private String metaDescription;

  private List<LocalizedString> metaDescriptionAllLocales;

  private Boolean hasStagedChanges;

  private Boolean published;

  private ProductVariant masterVariant;

  private List<ProductVariant> variants;

  private Reference taxCategoryRef;

  private TaxCategory taxCategory;

  private Reference stateRef;

  private State state;

  private ReviewRatingStatistics reviewRatingStatistics;

  public ProductProjectionMessagePayload() {
  }

  public ProductProjectionMessagePayload(String id, Long version, OffsetDateTime createdAt,
      OffsetDateTime lastModifiedAt, Reference productTypeRef, ProductTypeDefinition productType,
      String name, List<LocalizedString> nameAllLocales, String description,
      List<LocalizedString> descriptionAllLocales, String slug,
      List<LocalizedString> slugAllLocales, List<CategoryOrderHint> categoryOrderHints,
      List<Reference> categoriesRef, List<Category> categories, List<SearchKeywords> searchKeywords,
      String metaTitle, List<LocalizedString> metaTitleAllLocales, String metaKeywords,
      List<LocalizedString> metaKeywordsAllLocales, String metaDescription,
      List<LocalizedString> metaDescriptionAllLocales, Boolean hasStagedChanges, Boolean published,
      ProductVariant masterVariant, List<ProductVariant> variants, Reference taxCategoryRef,
      TaxCategory taxCategory, Reference stateRef, State state,
      ReviewRatingStatistics reviewRatingStatistics) {
    this.id = id;
    this.version = version;
    this.createdAt = createdAt;
    this.lastModifiedAt = lastModifiedAt;
    this.productTypeRef = productTypeRef;
    this.productType = productType;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.description = description;
    this.descriptionAllLocales = descriptionAllLocales;
    this.slug = slug;
    this.slugAllLocales = slugAllLocales;
    this.categoryOrderHints = categoryOrderHints;
    this.categoriesRef = categoriesRef;
    this.categories = categories;
    this.searchKeywords = searchKeywords;
    this.metaTitle = metaTitle;
    this.metaTitleAllLocales = metaTitleAllLocales;
    this.metaKeywords = metaKeywords;
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
    this.metaDescription = metaDescription;
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
    this.hasStagedChanges = hasStagedChanges;
    this.published = published;
    this.masterVariant = masterVariant;
    this.variants = variants;
    this.taxCategoryRef = taxCategoryRef;
    this.taxCategory = taxCategory;
    this.stateRef = stateRef;
    this.state = state;
    this.reviewRatingStatistics = reviewRatingStatistics;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public OffsetDateTime getCreatedAt() {
    return createdAt;
  }

  public void setCreatedAt(OffsetDateTime createdAt) {
    this.createdAt = createdAt;
  }

  public OffsetDateTime getLastModifiedAt() {
    return lastModifiedAt;
  }

  public void setLastModifiedAt(OffsetDateTime lastModifiedAt) {
    this.lastModifiedAt = lastModifiedAt;
  }

  public Reference getProductTypeRef() {
    return productTypeRef;
  }

  public void setProductTypeRef(Reference productTypeRef) {
    this.productTypeRef = productTypeRef;
  }

  public ProductTypeDefinition getProductType() {
    return productType;
  }

  public void setProductType(ProductTypeDefinition productType) {
    this.productType = productType;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public List<LocalizedString> getSlugAllLocales() {
    return slugAllLocales;
  }

  public void setSlugAllLocales(List<LocalizedString> slugAllLocales) {
    this.slugAllLocales = slugAllLocales;
  }

  public List<CategoryOrderHint> getCategoryOrderHints() {
    return categoryOrderHints;
  }

  public void setCategoryOrderHints(List<CategoryOrderHint> categoryOrderHints) {
    this.categoryOrderHints = categoryOrderHints;
  }

  public List<Reference> getCategoriesRef() {
    return categoriesRef;
  }

  public void setCategoriesRef(List<Reference> categoriesRef) {
    this.categoriesRef = categoriesRef;
  }

  public List<Category> getCategories() {
    return categories;
  }

  public void setCategories(List<Category> categories) {
    this.categories = categories;
  }

  public List<SearchKeywords> getSearchKeywords() {
    return searchKeywords;
  }

  public void setSearchKeywords(List<SearchKeywords> searchKeywords) {
    this.searchKeywords = searchKeywords;
  }

  public String getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(String metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedString> getMetaTitleAllLocales() {
    return metaTitleAllLocales;
  }

  public void setMetaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
    this.metaTitleAllLocales = metaTitleAllLocales;
  }

  public String getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(String metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public List<LocalizedString> getMetaKeywordsAllLocales() {
    return metaKeywordsAllLocales;
  }

  public void setMetaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
  }

  public String getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(String metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedString> getMetaDescriptionAllLocales() {
    return metaDescriptionAllLocales;
  }

  public void setMetaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
  }

  public Boolean getHasStagedChanges() {
    return hasStagedChanges;
  }

  public void setHasStagedChanges(Boolean hasStagedChanges) {
    this.hasStagedChanges = hasStagedChanges;
  }

  public Boolean getPublished() {
    return published;
  }

  public void setPublished(Boolean published) {
    this.published = published;
  }

  public ProductVariant getMasterVariant() {
    return masterVariant;
  }

  public void setMasterVariant(ProductVariant masterVariant) {
    this.masterVariant = masterVariant;
  }

  public List<ProductVariant> getVariants() {
    return variants;
  }

  public void setVariants(List<ProductVariant> variants) {
    this.variants = variants;
  }

  public Reference getTaxCategoryRef() {
    return taxCategoryRef;
  }

  public void setTaxCategoryRef(Reference taxCategoryRef) {
    this.taxCategoryRef = taxCategoryRef;
  }

  public TaxCategory getTaxCategory() {
    return taxCategory;
  }

  public void setTaxCategory(TaxCategory taxCategory) {
    this.taxCategory = taxCategory;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public ReviewRatingStatistics getReviewRatingStatistics() {
    return reviewRatingStatistics;
  }

  public void setReviewRatingStatistics(ReviewRatingStatistics reviewRatingStatistics) {
    this.reviewRatingStatistics = reviewRatingStatistics;
  }

  @Override
  public String toString() {
    return "ProductProjectionMessagePayload{id='" + id + "', version='" + version + "', createdAt='" + createdAt + "', lastModifiedAt='" + lastModifiedAt + "', productTypeRef='" + productTypeRef + "', productType='" + productType + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', description='" + description + "', descriptionAllLocales='" + descriptionAllLocales + "', slug='" + slug + "', slugAllLocales='" + slugAllLocales + "', categoryOrderHints='" + categoryOrderHints + "', categoriesRef='" + categoriesRef + "', categories='" + categories + "', searchKeywords='" + searchKeywords + "', metaTitle='" + metaTitle + "', metaTitleAllLocales='" + metaTitleAllLocales + "', metaKeywords='" + metaKeywords + "', metaKeywordsAllLocales='" + metaKeywordsAllLocales + "', metaDescription='" + metaDescription + "', metaDescriptionAllLocales='" + metaDescriptionAllLocales + "', hasStagedChanges='" + hasStagedChanges + "', published='" + published + "', masterVariant='" + masterVariant + "', variants='" + variants + "', taxCategoryRef='" + taxCategoryRef + "', taxCategory='" + taxCategory + "', stateRef='" + stateRef + "', state='" + state + "', reviewRatingStatistics='" + reviewRatingStatistics + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductProjectionMessagePayload that = (ProductProjectionMessagePayload) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(version, that.version) &&
        Objects.equals(createdAt, that.createdAt) &&
        Objects.equals(lastModifiedAt, that.lastModifiedAt) &&
        Objects.equals(productTypeRef, that.productTypeRef) &&
        Objects.equals(productType, that.productType) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(description, that.description) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(slugAllLocales, that.slugAllLocales) &&
        Objects.equals(categoryOrderHints, that.categoryOrderHints) &&
        Objects.equals(categoriesRef, that.categoriesRef) &&
        Objects.equals(categories, that.categories) &&
        Objects.equals(searchKeywords, that.searchKeywords) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(metaTitleAllLocales, that.metaTitleAllLocales) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(metaKeywordsAllLocales, that.metaKeywordsAllLocales) &&
        Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaDescriptionAllLocales, that.metaDescriptionAllLocales) &&
        Objects.equals(hasStagedChanges, that.hasStagedChanges) &&
        Objects.equals(published, that.published) &&
        Objects.equals(masterVariant, that.masterVariant) &&
        Objects.equals(variants, that.variants) &&
        Objects.equals(taxCategoryRef, that.taxCategoryRef) &&
        Objects.equals(taxCategory, that.taxCategory) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(state, that.state) &&
        Objects.equals(reviewRatingStatistics, that.reviewRatingStatistics);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, version, createdAt, lastModifiedAt, productTypeRef, productType, name, nameAllLocales, description, descriptionAllLocales, slug, slugAllLocales, categoryOrderHints, categoriesRef, categories, searchKeywords, metaTitle, metaTitleAllLocales, metaKeywords, metaKeywordsAllLocales, metaDescription, metaDescriptionAllLocales, hasStagedChanges, published, masterVariant, variants, taxCategoryRef, taxCategory, stateRef, state, reviewRatingStatistics);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String id;

    private Long version;

    private OffsetDateTime createdAt;

    private OffsetDateTime lastModifiedAt;

    private Reference productTypeRef;

    private ProductTypeDefinition productType;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private String description;

    private List<LocalizedString> descriptionAllLocales;

    private String slug;

    private List<LocalizedString> slugAllLocales;

    private List<CategoryOrderHint> categoryOrderHints;

    private List<Reference> categoriesRef;

    private List<Category> categories;

    private List<SearchKeywords> searchKeywords;

    private String metaTitle;

    private List<LocalizedString> metaTitleAllLocales;

    private String metaKeywords;

    private List<LocalizedString> metaKeywordsAllLocales;

    private String metaDescription;

    private List<LocalizedString> metaDescriptionAllLocales;

    private Boolean hasStagedChanges;

    private Boolean published;

    private ProductVariant masterVariant;

    private List<ProductVariant> variants;

    private Reference taxCategoryRef;

    private TaxCategory taxCategory;

    private Reference stateRef;

    private State state;

    private ReviewRatingStatistics reviewRatingStatistics;

    public ProductProjectionMessagePayload build() {
      ProductProjectionMessagePayload result = new ProductProjectionMessagePayload();
      result.id = this.id;
      result.version = this.version;
      result.createdAt = this.createdAt;
      result.lastModifiedAt = this.lastModifiedAt;
      result.productTypeRef = this.productTypeRef;
      result.productType = this.productType;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.description = this.description;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.slug = this.slug;
      result.slugAllLocales = this.slugAllLocales;
      result.categoryOrderHints = this.categoryOrderHints;
      result.categoriesRef = this.categoriesRef;
      result.categories = this.categories;
      result.searchKeywords = this.searchKeywords;
      result.metaTitle = this.metaTitle;
      result.metaTitleAllLocales = this.metaTitleAllLocales;
      result.metaKeywords = this.metaKeywords;
      result.metaKeywordsAllLocales = this.metaKeywordsAllLocales;
      result.metaDescription = this.metaDescription;
      result.metaDescriptionAllLocales = this.metaDescriptionAllLocales;
      result.hasStagedChanges = this.hasStagedChanges;
      result.published = this.published;
      result.masterVariant = this.masterVariant;
      result.variants = this.variants;
      result.taxCategoryRef = this.taxCategoryRef;
      result.taxCategory = this.taxCategory;
      result.stateRef = this.stateRef;
      result.state = this.state;
      result.reviewRatingStatistics = this.reviewRatingStatistics;
      return result;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder createdAt(OffsetDateTime createdAt) {
      this.createdAt = createdAt;
      return this;
    }

    public Builder lastModifiedAt(OffsetDateTime lastModifiedAt) {
      this.lastModifiedAt = lastModifiedAt;
      return this;
    }

    public Builder productTypeRef(Reference productTypeRef) {
      this.productTypeRef = productTypeRef;
      return this;
    }

    public Builder productType(ProductTypeDefinition productType) {
      this.productType = productType;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder slugAllLocales(List<LocalizedString> slugAllLocales) {
      this.slugAllLocales = slugAllLocales;
      return this;
    }

    public Builder categoryOrderHints(List<CategoryOrderHint> categoryOrderHints) {
      this.categoryOrderHints = categoryOrderHints;
      return this;
    }

    public Builder categoriesRef(List<Reference> categoriesRef) {
      this.categoriesRef = categoriesRef;
      return this;
    }

    public Builder categories(List<Category> categories) {
      this.categories = categories;
      return this;
    }

    public Builder searchKeywords(List<SearchKeywords> searchKeywords) {
      this.searchKeywords = searchKeywords;
      return this;
    }

    public Builder metaTitle(String metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder metaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
      this.metaTitleAllLocales = metaTitleAllLocales;
      return this;
    }

    public Builder metaKeywords(String metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder metaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
      this.metaKeywordsAllLocales = metaKeywordsAllLocales;
      return this;
    }

    public Builder metaDescription(String metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
      this.metaDescriptionAllLocales = metaDescriptionAllLocales;
      return this;
    }

    public Builder hasStagedChanges(Boolean hasStagedChanges) {
      this.hasStagedChanges = hasStagedChanges;
      return this;
    }

    public Builder published(Boolean published) {
      this.published = published;
      return this;
    }

    public Builder masterVariant(ProductVariant masterVariant) {
      this.masterVariant = masterVariant;
      return this;
    }

    public Builder variants(List<ProductVariant> variants) {
      this.variants = variants;
      return this;
    }

    public Builder taxCategoryRef(Reference taxCategoryRef) {
      this.taxCategoryRef = taxCategoryRef;
      return this;
    }

    public Builder taxCategory(TaxCategory taxCategory) {
      this.taxCategory = taxCategory;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder reviewRatingStatistics(ReviewRatingStatistics reviewRatingStatistics) {
      this.reviewRatingStatistics = reviewRatingStatistics;
      return this;
    }
  }
}
