package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductPublished implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductProjectionMessagePayload productProjection;

  private List<String> removedImageUrls;

  private PublishScope scope;

  private String type;

  public ProductPublished() {
  }

  public ProductPublished(ProductProjectionMessagePayload productProjection,
      List<String> removedImageUrls, PublishScope scope, String type) {
    this.productProjection = productProjection;
    this.removedImageUrls = removedImageUrls;
    this.scope = scope;
    this.type = type;
  }

  public ProductProjectionMessagePayload getProductProjection() {
    return productProjection;
  }

  public void setProductProjection(ProductProjectionMessagePayload productProjection) {
    this.productProjection = productProjection;
  }

  public List<String> getRemovedImageUrls() {
    return removedImageUrls;
  }

  public void setRemovedImageUrls(List<String> removedImageUrls) {
    this.removedImageUrls = removedImageUrls;
  }

  public PublishScope getScope() {
    return scope;
  }

  public void setScope(PublishScope scope) {
    this.scope = scope;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductPublished{productProjection='" + productProjection + "', removedImageUrls='" + removedImageUrls + "', scope='" + scope + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductPublished that = (ProductPublished) o;
    return Objects.equals(productProjection, that.productProjection) &&
        Objects.equals(removedImageUrls, that.removedImageUrls) &&
        Objects.equals(scope, that.scope) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productProjection, removedImageUrls, scope, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductProjectionMessagePayload productProjection;

    private List<String> removedImageUrls;

    private PublishScope scope;

    private String type;

    public ProductPublished build() {
      ProductPublished result = new ProductPublished();
      result.productProjection = this.productProjection;
      result.removedImageUrls = this.removedImageUrls;
      result.scope = this.scope;
      result.type = this.type;
      return result;
    }

    public Builder productProjection(ProductProjectionMessagePayload productProjection) {
      this.productProjection = productProjection;
      return this;
    }

    public Builder removedImageUrls(List<String> removedImageUrls) {
      this.removedImageUrls = removedImageUrls;
      return this;
    }

    public Builder scope(PublishScope scope) {
      this.scope = scope;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
