package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductRemovedFromCategory implements com.commercetools.graphql.api.types.MessagePayload {
  private ReferenceId category;

  private Boolean staged;

  private String type;

  public ProductRemovedFromCategory() {
  }

  public ProductRemovedFromCategory(ReferenceId category, Boolean staged, String type) {
    this.category = category;
    this.staged = staged;
    this.type = type;
  }

  public ReferenceId getCategory() {
    return category;
  }

  public void setCategory(ReferenceId category) {
    this.category = category;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductRemovedFromCategory{category='" + category + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductRemovedFromCategory that = (ProductRemovedFromCategory) o;
    return Objects.equals(category, that.category) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(category, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ReferenceId category;

    private Boolean staged;

    private String type;

    public ProductRemovedFromCategory build() {
      ProductRemovedFromCategory result = new ProductRemovedFromCategory();
      result.category = this.category;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder category(ReferenceId category) {
      this.category = category;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
