package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductSearchPriceTier {
  private Integer minimumQuantity;

  private BaseMoney value;

  public ProductSearchPriceTier() {
  }

  public ProductSearchPriceTier(Integer minimumQuantity, BaseMoney value) {
    this.minimumQuantity = minimumQuantity;
    this.value = value;
  }

  public Integer getMinimumQuantity() {
    return minimumQuantity;
  }

  public void setMinimumQuantity(Integer minimumQuantity) {
    this.minimumQuantity = minimumQuantity;
  }

  public BaseMoney getValue() {
    return value;
  }

  public void setValue(BaseMoney value) {
    this.value = value;
  }

  @Override
  public String toString() {
    return "ProductSearchPriceTier{minimumQuantity='" + minimumQuantity + "', value='" + value + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSearchPriceTier that = (ProductSearchPriceTier) o;
    return Objects.equals(minimumQuantity, that.minimumQuantity) &&
        Objects.equals(value, that.value);
  }

  @Override
  public int hashCode() {
    return Objects.hash(minimumQuantity, value);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer minimumQuantity;

    private BaseMoney value;

    public ProductSearchPriceTier build() {
      ProductSearchPriceTier result = new ProductSearchPriceTier();
      result.minimumQuantity = this.minimumQuantity;
      result.value = this.value;
      return result;
    }

    public Builder minimumQuantity(Integer minimumQuantity) {
      this.minimumQuantity = minimumQuantity;
      return this;
    }

    public Builder value(BaseMoney value) {
      this.value = value;
      return this;
    }
  }
}
