package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductSearchVariant {
  private Integer id;

  private String key;

  private String sku;

  private List<ProductPriceSearch> prices;

  /**
   * Returns a single price based on the price selection rules.
   */
  private ProductPriceSearch price;

  private List<ImageProductSearch> images;

  private List<Asset> assets;

  private ProductSearchVariantAvailabilityWithChannels availability;

  /**
   * This field contains raw attributes data
   */
  private List<RawProductSearchAttribute> attributesRaw;

  private Boolean isMatchingVariant;

  private ScopedPrice scopedPrice;

  private Boolean scopedPriceDiscounted;

  public ProductSearchVariant() {
  }

  public ProductSearchVariant(Integer id, String key, String sku, List<ProductPriceSearch> prices,
      ProductPriceSearch price, List<ImageProductSearch> images, List<Asset> assets,
      ProductSearchVariantAvailabilityWithChannels availability,
      List<RawProductSearchAttribute> attributesRaw, Boolean isMatchingVariant,
      ScopedPrice scopedPrice, Boolean scopedPriceDiscounted) {
    this.id = id;
    this.key = key;
    this.sku = sku;
    this.prices = prices;
    this.price = price;
    this.images = images;
    this.assets = assets;
    this.availability = availability;
    this.attributesRaw = attributesRaw;
    this.isMatchingVariant = isMatchingVariant;
    this.scopedPrice = scopedPrice;
    this.scopedPriceDiscounted = scopedPriceDiscounted;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public List<ProductPriceSearch> getPrices() {
    return prices;
  }

  public void setPrices(List<ProductPriceSearch> prices) {
    this.prices = prices;
  }

  /**
   * Returns a single price based on the price selection rules.
   */
  public ProductPriceSearch getPrice() {
    return price;
  }

  public void setPrice(ProductPriceSearch price) {
    this.price = price;
  }

  public List<ImageProductSearch> getImages() {
    return images;
  }

  public void setImages(List<ImageProductSearch> images) {
    this.images = images;
  }

  public List<Asset> getAssets() {
    return assets;
  }

  public void setAssets(List<Asset> assets) {
    this.assets = assets;
  }

  public ProductSearchVariantAvailabilityWithChannels getAvailability() {
    return availability;
  }

  public void setAvailability(ProductSearchVariantAvailabilityWithChannels availability) {
    this.availability = availability;
  }

  /**
   * This field contains raw attributes data
   */
  public List<RawProductSearchAttribute> getAttributesRaw() {
    return attributesRaw;
  }

  public void setAttributesRaw(List<RawProductSearchAttribute> attributesRaw) {
    this.attributesRaw = attributesRaw;
  }

  public Boolean getIsMatchingVariant() {
    return isMatchingVariant;
  }

  public void setIsMatchingVariant(Boolean isMatchingVariant) {
    this.isMatchingVariant = isMatchingVariant;
  }

  public ScopedPrice getScopedPrice() {
    return scopedPrice;
  }

  public void setScopedPrice(ScopedPrice scopedPrice) {
    this.scopedPrice = scopedPrice;
  }

  public Boolean getScopedPriceDiscounted() {
    return scopedPriceDiscounted;
  }

  public void setScopedPriceDiscounted(Boolean scopedPriceDiscounted) {
    this.scopedPriceDiscounted = scopedPriceDiscounted;
  }

  @Override
  public String toString() {
    return "ProductSearchVariant{id='" + id + "', key='" + key + "', sku='" + sku + "', prices='" + prices + "', price='" + price + "', images='" + images + "', assets='" + assets + "', availability='" + availability + "', attributesRaw='" + attributesRaw + "', isMatchingVariant='" + isMatchingVariant + "', scopedPrice='" + scopedPrice + "', scopedPriceDiscounted='" + scopedPriceDiscounted + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSearchVariant that = (ProductSearchVariant) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(prices, that.prices) &&
        Objects.equals(price, that.price) &&
        Objects.equals(images, that.images) &&
        Objects.equals(assets, that.assets) &&
        Objects.equals(availability, that.availability) &&
        Objects.equals(attributesRaw, that.attributesRaw) &&
        Objects.equals(isMatchingVariant, that.isMatchingVariant) &&
        Objects.equals(scopedPrice, that.scopedPrice) &&
        Objects.equals(scopedPriceDiscounted, that.scopedPriceDiscounted);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, sku, prices, price, images, assets, availability, attributesRaw, isMatchingVariant, scopedPrice, scopedPriceDiscounted);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer id;

    private String key;

    private String sku;

    private List<ProductPriceSearch> prices;

    /**
     * Returns a single price based on the price selection rules.
     */
    private ProductPriceSearch price;

    private List<ImageProductSearch> images;

    private List<Asset> assets;

    private ProductSearchVariantAvailabilityWithChannels availability;

    /**
     * This field contains raw attributes data
     */
    private List<RawProductSearchAttribute> attributesRaw;

    private Boolean isMatchingVariant;

    private ScopedPrice scopedPrice;

    private Boolean scopedPriceDiscounted;

    public ProductSearchVariant build() {
      ProductSearchVariant result = new ProductSearchVariant();
      result.id = this.id;
      result.key = this.key;
      result.sku = this.sku;
      result.prices = this.prices;
      result.price = this.price;
      result.images = this.images;
      result.assets = this.assets;
      result.availability = this.availability;
      result.attributesRaw = this.attributesRaw;
      result.isMatchingVariant = this.isMatchingVariant;
      result.scopedPrice = this.scopedPrice;
      result.scopedPriceDiscounted = this.scopedPriceDiscounted;
      return result;
    }

    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder prices(List<ProductPriceSearch> prices) {
      this.prices = prices;
      return this;
    }

    /**
     * Returns a single price based on the price selection rules.
     */
    public Builder price(ProductPriceSearch price) {
      this.price = price;
      return this;
    }

    public Builder images(List<ImageProductSearch> images) {
      this.images = images;
      return this;
    }

    public Builder assets(List<Asset> assets) {
      this.assets = assets;
      return this;
    }

    public Builder availability(ProductSearchVariantAvailabilityWithChannels availability) {
      this.availability = availability;
      return this;
    }

    /**
     * This field contains raw attributes data
     */
    public Builder attributesRaw(List<RawProductSearchAttribute> attributesRaw) {
      this.attributesRaw = attributesRaw;
      return this;
    }

    public Builder isMatchingVariant(Boolean isMatchingVariant) {
      this.isMatchingVariant = isMatchingVariant;
      return this;
    }

    public Builder scopedPrice(ScopedPrice scopedPrice) {
      this.scopedPrice = scopedPrice;
      return this;
    }

    public Builder scopedPriceDiscounted(Boolean scopedPriceDiscounted) {
      this.scopedPriceDiscounted = scopedPriceDiscounted;
      return this;
    }
  }
}
