package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductSearchVariantAvailabilityWithChannel {
  private Reference channelRef;

  private Channel channel;

  private ProductSearchVariantAvailability availability;

  public ProductSearchVariantAvailabilityWithChannel() {
  }

  public ProductSearchVariantAvailabilityWithChannel(Reference channelRef, Channel channel,
      ProductSearchVariantAvailability availability) {
    this.channelRef = channelRef;
    this.channel = channel;
    this.availability = availability;
  }

  public Reference getChannelRef() {
    return channelRef;
  }

  public void setChannelRef(Reference channelRef) {
    this.channelRef = channelRef;
  }

  public Channel getChannel() {
    return channel;
  }

  public void setChannel(Channel channel) {
    this.channel = channel;
  }

  public ProductSearchVariantAvailability getAvailability() {
    return availability;
  }

  public void setAvailability(ProductSearchVariantAvailability availability) {
    this.availability = availability;
  }

  @Override
  public String toString() {
    return "ProductSearchVariantAvailabilityWithChannel{channelRef='" + channelRef + "', channel='" + channel + "', availability='" + availability + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSearchVariantAvailabilityWithChannel that = (ProductSearchVariantAvailabilityWithChannel) o;
    return Objects.equals(channelRef, that.channelRef) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(availability, that.availability);
  }

  @Override
  public int hashCode() {
    return Objects.hash(channelRef, channel, availability);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference channelRef;

    private Channel channel;

    private ProductSearchVariantAvailability availability;

    public ProductSearchVariantAvailabilityWithChannel build() {
      ProductSearchVariantAvailabilityWithChannel result = new ProductSearchVariantAvailabilityWithChannel();
      result.channelRef = this.channelRef;
      result.channel = this.channel;
      result.availability = this.availability;
      return result;
    }

    public Builder channelRef(Reference channelRef) {
      this.channelRef = channelRef;
      return this;
    }

    public Builder channel(Channel channel) {
      this.channel = channel;
      return this;
    }

    public Builder availability(ProductSearchVariantAvailability availability) {
      this.availability = availability;
      return this;
    }
  }
}
