package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductSelectionCreated implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductSelection productSelection;

  private String type;

  public ProductSelectionCreated() {
  }

  public ProductSelectionCreated(ProductSelection productSelection, String type) {
    this.productSelection = productSelection;
    this.type = type;
  }

  public ProductSelection getProductSelection() {
    return productSelection;
  }

  public void setProductSelection(ProductSelection productSelection) {
    this.productSelection = productSelection;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductSelectionCreated{productSelection='" + productSelection + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionCreated that = (ProductSelectionCreated) o;
    return Objects.equals(productSelection, that.productSelection) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productSelection, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductSelection productSelection;

    private String type;

    public ProductSelectionCreated build() {
      ProductSelectionCreated result = new ProductSelectionCreated();
      result.productSelection = this.productSelection;
      result.type = this.type;
      return result;
    }

    public Builder productSelection(ProductSelection productSelection) {
      this.productSelection = productSelection;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
