package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductSelectionProductRemoved implements com.commercetools.graphql.api.types.MessagePayload {
  private Product product;

  private Reference productRef;

  private String type;

  public ProductSelectionProductRemoved() {
  }

  public ProductSelectionProductRemoved(Product product, Reference productRef, String type) {
    this.product = product;
    this.productRef = productRef;
    this.type = type;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductSelectionProductRemoved{product='" + product + "', productRef='" + productRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionProductRemoved that = (ProductSelectionProductRemoved) o;
    return Objects.equals(product, that.product) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, productRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Product product;

    private Reference productRef;

    private String type;

    public ProductSelectionProductRemoved build() {
      ProductSelectionProductRemoved result = new ProductSelectionProductRemoved();
      result.product = this.product;
      result.productRef = this.productRef;
      result.type = this.type;
      return result;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
