package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductSelectionSetting {
  private Reference productSelectionRef;

  private ProductSelection productSelection;

  private Boolean active;

  public ProductSelectionSetting() {
  }

  public ProductSelectionSetting(Reference productSelectionRef, ProductSelection productSelection,
      Boolean active) {
    this.productSelectionRef = productSelectionRef;
    this.productSelection = productSelection;
    this.active = active;
  }

  public Reference getProductSelectionRef() {
    return productSelectionRef;
  }

  public void setProductSelectionRef(Reference productSelectionRef) {
    this.productSelectionRef = productSelectionRef;
  }

  public ProductSelection getProductSelection() {
    return productSelection;
  }

  public void setProductSelection(ProductSelection productSelection) {
    this.productSelection = productSelection;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  @Override
  public String toString() {
    return "ProductSelectionSetting{productSelectionRef='" + productSelectionRef + "', productSelection='" + productSelection + "', active='" + active + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionSetting that = (ProductSelectionSetting) o;
    return Objects.equals(productSelectionRef, that.productSelectionRef) &&
        Objects.equals(productSelection, that.productSelection) &&
        Objects.equals(active, that.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productSelectionRef, productSelection, active);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference productSelectionRef;

    private ProductSelection productSelection;

    private Boolean active;

    public ProductSelectionSetting build() {
      ProductSelectionSetting result = new ProductSelectionSetting();
      result.productSelectionRef = this.productSelectionRef;
      result.productSelection = this.productSelection;
      result.active = this.active;
      return result;
    }

    public Builder productSelectionRef(Reference productSelectionRef) {
      this.productSelectionRef = productSelectionRef;
      return this;
    }

    public Builder productSelection(ProductSelection productSelection) {
      this.productSelection = productSelection;
      return this;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }
  }
}
