package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductSelectionSettingDraft {
  private ResourceIdentifierInput productSelection;

  private Boolean active;

  public ProductSelectionSettingDraft() {
  }

  public ProductSelectionSettingDraft(ResourceIdentifierInput productSelection, Boolean active) {
    this.productSelection = productSelection;
    this.active = active;
  }

  public ResourceIdentifierInput getProductSelection() {
    return productSelection;
  }

  public void setProductSelection(ResourceIdentifierInput productSelection) {
    this.productSelection = productSelection;
  }

  public Boolean getActive() {
    return active;
  }

  public void setActive(Boolean active) {
    this.active = active;
  }

  @Override
  public String toString() {
    return "ProductSelectionSettingDraft{productSelection='" + productSelection + "', active='" + active + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionSettingDraft that = (ProductSelectionSettingDraft) o;
    return Objects.equals(productSelection, that.productSelection) &&
        Objects.equals(active, that.active);
  }

  @Override
  public int hashCode() {
    return Objects.hash(productSelection, active);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput productSelection;

    private Boolean active;

    public ProductSelectionSettingDraft build() {
      ProductSelectionSettingDraft result = new ProductSelectionSettingDraft();
      result.productSelection = this.productSelection;
      result.active = this.active;
      return result;
    }

    public Builder productSelection(ResourceIdentifierInput productSelection) {
      this.productSelection = productSelection;
      return this;
    }

    public Builder active(Boolean active) {
      this.active = active;
      return this;
    }
  }
}
