package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductSelectionVariantExclusionChanged implements com.commercetools.graphql.api.types.MessagePayload {
  private ProductVariantExclusion oldVariantExclusion;

  private ProductVariantExclusion newVariantExclusion;

  private Product product;

  private Reference productRef;

  private String type;

  public ProductSelectionVariantExclusionChanged() {
  }

  public ProductSelectionVariantExclusionChanged(ProductVariantExclusion oldVariantExclusion,
      ProductVariantExclusion newVariantExclusion, Product product, Reference productRef,
      String type) {
    this.oldVariantExclusion = oldVariantExclusion;
    this.newVariantExclusion = newVariantExclusion;
    this.product = product;
    this.productRef = productRef;
    this.type = type;
  }

  public ProductVariantExclusion getOldVariantExclusion() {
    return oldVariantExclusion;
  }

  public void setOldVariantExclusion(ProductVariantExclusion oldVariantExclusion) {
    this.oldVariantExclusion = oldVariantExclusion;
  }

  public ProductVariantExclusion getNewVariantExclusion() {
    return newVariantExclusion;
  }

  public void setNewVariantExclusion(ProductVariantExclusion newVariantExclusion) {
    this.newVariantExclusion = newVariantExclusion;
  }

  public Product getProduct() {
    return product;
  }

  public void setProduct(Product product) {
    this.product = product;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductSelectionVariantExclusionChanged{oldVariantExclusion='" + oldVariantExclusion + "', newVariantExclusion='" + newVariantExclusion + "', product='" + product + "', productRef='" + productRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductSelectionVariantExclusionChanged that = (ProductSelectionVariantExclusionChanged) o;
    return Objects.equals(oldVariantExclusion, that.oldVariantExclusion) &&
        Objects.equals(newVariantExclusion, that.newVariantExclusion) &&
        Objects.equals(product, that.product) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(oldVariantExclusion, newVariantExclusion, product, productRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductVariantExclusion oldVariantExclusion;

    private ProductVariantExclusion newVariantExclusion;

    private Product product;

    private Reference productRef;

    private String type;

    public ProductSelectionVariantExclusionChanged build() {
      ProductSelectionVariantExclusionChanged result = new ProductSelectionVariantExclusionChanged();
      result.oldVariantExclusion = this.oldVariantExclusion;
      result.newVariantExclusion = this.newVariantExclusion;
      result.product = this.product;
      result.productRef = this.productRef;
      result.type = this.type;
      return result;
    }

    public Builder oldVariantExclusion(ProductVariantExclusion oldVariantExclusion) {
      this.oldVariantExclusion = oldVariantExclusion;
      return this;
    }

    public Builder newVariantExclusion(ProductVariantExclusion newVariantExclusion) {
      this.newVariantExclusion = newVariantExclusion;
      return this;
    }

    public Builder product(Product product) {
      this.product = product;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
