package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductStateTransition implements com.commercetools.graphql.api.types.MessagePayload {
  private Boolean force;

  private State state;

  private Reference stateRef;

  private String type;

  public ProductStateTransition() {
  }

  public ProductStateTransition(Boolean force, State state, Reference stateRef, String type) {
    this.force = force;
    this.state = state;
    this.stateRef = stateRef;
    this.type = type;
  }

  public Boolean getForce() {
    return force;
  }

  public void setForce(Boolean force) {
    this.force = force;
  }

  public State getState() {
    return state;
  }

  public void setState(State state) {
    this.state = state;
  }

  public Reference getStateRef() {
    return stateRef;
  }

  public void setStateRef(Reference stateRef) {
    this.stateRef = stateRef;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductStateTransition{force='" + force + "', state='" + state + "', stateRef='" + stateRef + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductStateTransition that = (ProductStateTransition) o;
    return Objects.equals(force, that.force) &&
        Objects.equals(state, that.state) &&
        Objects.equals(stateRef, that.stateRef) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(force, state, stateRef, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean force;

    private State state;

    private Reference stateRef;

    private String type;

    public ProductStateTransition build() {
      ProductStateTransition result = new ProductStateTransition();
      result.force = this.force;
      result.state = this.state;
      result.stateRef = this.stateRef;
      result.type = this.type;
      return result;
    }

    public Builder force(Boolean force) {
      this.force = force;
      return this;
    }

    public Builder state(State state) {
      this.state = state;
      return this;
    }

    public Builder stateRef(Reference stateRef) {
      this.stateRef = stateRef;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
