package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoringCreated implements com.commercetools.graphql.api.types.MessagePayload, com.commercetools.graphql.api.types.HasProductTailoringData {
  private String type;

  private KeyReference storeRef;

  private Reference productRef;

  private String key;

  private String productKey;

  private Boolean publish;

  private String name;

  private List<LocalizedString> nameAllLocales;

  private String description;

  private List<LocalizedString> descriptionAllLocales;

  private String slug;

  private List<LocalizedString> slugAllLocales;

  private String metaTitle;

  private List<LocalizedString> metaTitleAllLocales;

  private String metaDescription;

  private List<LocalizedString> metaDescriptionAllLocales;

  private String metaKeywords;

  private List<LocalizedString> metaKeywordsAllLocales;

  private List<ProductVariantTailoring> variants;

  public ProductTailoringCreated() {
  }

  public ProductTailoringCreated(String type, KeyReference storeRef, Reference productRef,
      String key, String productKey, Boolean publish, String name,
      List<LocalizedString> nameAllLocales, String description,
      List<LocalizedString> descriptionAllLocales, String slug,
      List<LocalizedString> slugAllLocales, String metaTitle,
      List<LocalizedString> metaTitleAllLocales, String metaDescription,
      List<LocalizedString> metaDescriptionAllLocales, String metaKeywords,
      List<LocalizedString> metaKeywordsAllLocales, List<ProductVariantTailoring> variants) {
    this.type = type;
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.key = key;
    this.productKey = productKey;
    this.publish = publish;
    this.name = name;
    this.nameAllLocales = nameAllLocales;
    this.description = description;
    this.descriptionAllLocales = descriptionAllLocales;
    this.slug = slug;
    this.slugAllLocales = slugAllLocales;
    this.metaTitle = metaTitle;
    this.metaTitleAllLocales = metaTitleAllLocales;
    this.metaDescription = metaDescription;
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
    this.metaKeywords = metaKeywords;
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
    this.variants = variants;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public Boolean getPublish() {
    return publish;
  }

  public void setPublish(Boolean publish) {
    this.publish = publish;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public List<LocalizedString> getNameAllLocales() {
    return nameAllLocales;
  }

  public void setNameAllLocales(List<LocalizedString> nameAllLocales) {
    this.nameAllLocales = nameAllLocales;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public List<LocalizedString> getSlugAllLocales() {
    return slugAllLocales;
  }

  public void setSlugAllLocales(List<LocalizedString> slugAllLocales) {
    this.slugAllLocales = slugAllLocales;
  }

  public String getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(String metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedString> getMetaTitleAllLocales() {
    return metaTitleAllLocales;
  }

  public void setMetaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
    this.metaTitleAllLocales = metaTitleAllLocales;
  }

  public String getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(String metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedString> getMetaDescriptionAllLocales() {
    return metaDescriptionAllLocales;
  }

  public void setMetaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
    this.metaDescriptionAllLocales = metaDescriptionAllLocales;
  }

  public String getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(String metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public List<LocalizedString> getMetaKeywordsAllLocales() {
    return metaKeywordsAllLocales;
  }

  public void setMetaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
    this.metaKeywordsAllLocales = metaKeywordsAllLocales;
  }

  public List<ProductVariantTailoring> getVariants() {
    return variants;
  }

  public void setVariants(List<ProductVariantTailoring> variants) {
    this.variants = variants;
  }

  @Override
  public String toString() {
    return "ProductTailoringCreated{type='" + type + "', storeRef='" + storeRef + "', productRef='" + productRef + "', key='" + key + "', productKey='" + productKey + "', publish='" + publish + "', name='" + name + "', nameAllLocales='" + nameAllLocales + "', description='" + description + "', descriptionAllLocales='" + descriptionAllLocales + "', slug='" + slug + "', slugAllLocales='" + slugAllLocales + "', metaTitle='" + metaTitle + "', metaTitleAllLocales='" + metaTitleAllLocales + "', metaDescription='" + metaDescription + "', metaDescriptionAllLocales='" + metaDescriptionAllLocales + "', metaKeywords='" + metaKeywords + "', metaKeywordsAllLocales='" + metaKeywordsAllLocales + "', variants='" + variants + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringCreated that = (ProductTailoringCreated) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(key, that.key) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(publish, that.publish) &&
        Objects.equals(name, that.name) &&
        Objects.equals(nameAllLocales, that.nameAllLocales) &&
        Objects.equals(description, that.description) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(slugAllLocales, that.slugAllLocales) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(metaTitleAllLocales, that.metaTitleAllLocales) &&
        Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaDescriptionAllLocales, that.metaDescriptionAllLocales) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(metaKeywordsAllLocales, that.metaKeywordsAllLocales) &&
        Objects.equals(variants, that.variants);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, storeRef, productRef, key, productKey, publish, name, nameAllLocales, description, descriptionAllLocales, slug, slugAllLocales, metaTitle, metaTitleAllLocales, metaDescription, metaDescriptionAllLocales, metaKeywords, metaKeywordsAllLocales, variants);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private KeyReference storeRef;

    private Reference productRef;

    private String key;

    private String productKey;

    private Boolean publish;

    private String name;

    private List<LocalizedString> nameAllLocales;

    private String description;

    private List<LocalizedString> descriptionAllLocales;

    private String slug;

    private List<LocalizedString> slugAllLocales;

    private String metaTitle;

    private List<LocalizedString> metaTitleAllLocales;

    private String metaDescription;

    private List<LocalizedString> metaDescriptionAllLocales;

    private String metaKeywords;

    private List<LocalizedString> metaKeywordsAllLocales;

    private List<ProductVariantTailoring> variants;

    public ProductTailoringCreated build() {
      ProductTailoringCreated result = new ProductTailoringCreated();
      result.type = this.type;
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.key = this.key;
      result.productKey = this.productKey;
      result.publish = this.publish;
      result.name = this.name;
      result.nameAllLocales = this.nameAllLocales;
      result.description = this.description;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.slug = this.slug;
      result.slugAllLocales = this.slugAllLocales;
      result.metaTitle = this.metaTitle;
      result.metaTitleAllLocales = this.metaTitleAllLocales;
      result.metaDescription = this.metaDescription;
      result.metaDescriptionAllLocales = this.metaDescriptionAllLocales;
      result.metaKeywords = this.metaKeywords;
      result.metaKeywordsAllLocales = this.metaKeywordsAllLocales;
      result.variants = this.variants;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder publish(Boolean publish) {
      this.publish = publish;
      return this;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder nameAllLocales(List<LocalizedString> nameAllLocales) {
      this.nameAllLocales = nameAllLocales;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder slugAllLocales(List<LocalizedString> slugAllLocales) {
      this.slugAllLocales = slugAllLocales;
      return this;
    }

    public Builder metaTitle(String metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder metaTitleAllLocales(List<LocalizedString> metaTitleAllLocales) {
      this.metaTitleAllLocales = metaTitleAllLocales;
      return this;
    }

    public Builder metaDescription(String metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaDescriptionAllLocales(List<LocalizedString> metaDescriptionAllLocales) {
      this.metaDescriptionAllLocales = metaDescriptionAllLocales;
      return this;
    }

    public Builder metaKeywords(String metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder metaKeywordsAllLocales(List<LocalizedString> metaKeywordsAllLocales) {
      this.metaKeywordsAllLocales = metaKeywordsAllLocales;
      return this;
    }

    public Builder variants(List<ProductVariantTailoring> variants) {
      this.variants = variants;
      return this;
    }
  }
}
