package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoringDescriptionSet implements com.commercetools.graphql.api.types.MessagePayload {
  private KeyReference storeRef;

  private Reference productRef;

  private String productKey;

  private String description;

  private String oldDescription;

  private List<LocalizedString> descriptionAllLocales;

  private List<LocalizedString> oldDescriptionAllLocales;

  private String type;

  public ProductTailoringDescriptionSet() {
  }

  public ProductTailoringDescriptionSet(KeyReference storeRef, Reference productRef,
      String productKey, String description, String oldDescription,
      List<LocalizedString> descriptionAllLocales, List<LocalizedString> oldDescriptionAllLocales,
      String type) {
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.productKey = productKey;
    this.description = description;
    this.oldDescription = oldDescription;
    this.descriptionAllLocales = descriptionAllLocales;
    this.oldDescriptionAllLocales = oldDescriptionAllLocales;
    this.type = type;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getOldDescription() {
    return oldDescription;
  }

  public void setOldDescription(String oldDescription) {
    this.oldDescription = oldDescription;
  }

  public List<LocalizedString> getDescriptionAllLocales() {
    return descriptionAllLocales;
  }

  public void setDescriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
    this.descriptionAllLocales = descriptionAllLocales;
  }

  public List<LocalizedString> getOldDescriptionAllLocales() {
    return oldDescriptionAllLocales;
  }

  public void setOldDescriptionAllLocales(List<LocalizedString> oldDescriptionAllLocales) {
    this.oldDescriptionAllLocales = oldDescriptionAllLocales;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductTailoringDescriptionSet{storeRef='" + storeRef + "', productRef='" + productRef + "', productKey='" + productKey + "', description='" + description + "', oldDescription='" + oldDescription + "', descriptionAllLocales='" + descriptionAllLocales + "', oldDescriptionAllLocales='" + oldDescriptionAllLocales + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringDescriptionSet that = (ProductTailoringDescriptionSet) o;
    return Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(description, that.description) &&
        Objects.equals(oldDescription, that.oldDescription) &&
        Objects.equals(descriptionAllLocales, that.descriptionAllLocales) &&
        Objects.equals(oldDescriptionAllLocales, that.oldDescriptionAllLocales) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(storeRef, productRef, productKey, description, oldDescription, descriptionAllLocales, oldDescriptionAllLocales, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private KeyReference storeRef;

    private Reference productRef;

    private String productKey;

    private String description;

    private String oldDescription;

    private List<LocalizedString> descriptionAllLocales;

    private List<LocalizedString> oldDescriptionAllLocales;

    private String type;

    public ProductTailoringDescriptionSet build() {
      ProductTailoringDescriptionSet result = new ProductTailoringDescriptionSet();
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.productKey = this.productKey;
      result.description = this.description;
      result.oldDescription = this.oldDescription;
      result.descriptionAllLocales = this.descriptionAllLocales;
      result.oldDescriptionAllLocales = this.oldDescriptionAllLocales;
      result.type = this.type;
      return result;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder oldDescription(String oldDescription) {
      this.oldDescription = oldDescription;
      return this;
    }

    public Builder descriptionAllLocales(List<LocalizedString> descriptionAllLocales) {
      this.descriptionAllLocales = descriptionAllLocales;
      return this;
    }

    public Builder oldDescriptionAllLocales(List<LocalizedString> oldDescriptionAllLocales) {
      this.oldDescriptionAllLocales = oldDescriptionAllLocales;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
