package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductTailoringDraft {
  private ResourceIdentifierInput product;

  private List<LocalizedStringItemInputType> name;

  private String key;

  private List<LocalizedStringItemInputType> description;

  private List<LocalizedStringItemInputType> slug;

  private List<LocalizedStringItemInputType> metaTitle;

  private List<LocalizedStringItemInputType> metaDescription;

  private List<LocalizedStringItemInputType> metaKeywords;

  private Boolean publish;

  private List<ProductVariantTailoringInput> variants = Collections.emptyList();

  public ProductTailoringDraft() {
  }

  public ProductTailoringDraft(ResourceIdentifierInput product,
      List<LocalizedStringItemInputType> name, String key,
      List<LocalizedStringItemInputType> description, List<LocalizedStringItemInputType> slug,
      List<LocalizedStringItemInputType> metaTitle,
      List<LocalizedStringItemInputType> metaDescription,
      List<LocalizedStringItemInputType> metaKeywords, Boolean publish,
      List<ProductVariantTailoringInput> variants) {
    this.product = product;
    this.name = name;
    this.key = key;
    this.description = description;
    this.slug = slug;
    this.metaTitle = metaTitle;
    this.metaDescription = metaDescription;
    this.metaKeywords = metaKeywords;
    this.publish = publish;
    this.variants = variants;
  }

  public ResourceIdentifierInput getProduct() {
    return product;
  }

  public void setProduct(ResourceIdentifierInput product) {
    this.product = product;
  }

  public List<LocalizedStringItemInputType> getName() {
    return name;
  }

  public void setName(List<LocalizedStringItemInputType> name) {
    this.name = name;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<LocalizedStringItemInputType> getDescription() {
    return description;
  }

  public void setDescription(List<LocalizedStringItemInputType> description) {
    this.description = description;
  }

  public List<LocalizedStringItemInputType> getSlug() {
    return slug;
  }

  public void setSlug(List<LocalizedStringItemInputType> slug) {
    this.slug = slug;
  }

  public List<LocalizedStringItemInputType> getMetaTitle() {
    return metaTitle;
  }

  public void setMetaTitle(List<LocalizedStringItemInputType> metaTitle) {
    this.metaTitle = metaTitle;
  }

  public List<LocalizedStringItemInputType> getMetaDescription() {
    return metaDescription;
  }

  public void setMetaDescription(List<LocalizedStringItemInputType> metaDescription) {
    this.metaDescription = metaDescription;
  }

  public List<LocalizedStringItemInputType> getMetaKeywords() {
    return metaKeywords;
  }

  public void setMetaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
    this.metaKeywords = metaKeywords;
  }

  public Boolean getPublish() {
    return publish;
  }

  public void setPublish(Boolean publish) {
    this.publish = publish;
  }

  public List<ProductVariantTailoringInput> getVariants() {
    return variants;
  }

  public void setVariants(List<ProductVariantTailoringInput> variants) {
    this.variants = variants;
  }

  @Override
  public String toString() {
    return "ProductTailoringDraft{product='" + product + "', name='" + name + "', key='" + key + "', description='" + description + "', slug='" + slug + "', metaTitle='" + metaTitle + "', metaDescription='" + metaDescription + "', metaKeywords='" + metaKeywords + "', publish='" + publish + "', variants='" + variants + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringDraft that = (ProductTailoringDraft) o;
    return Objects.equals(product, that.product) &&
        Objects.equals(name, that.name) &&
        Objects.equals(key, that.key) &&
        Objects.equals(description, that.description) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(metaTitle, that.metaTitle) &&
        Objects.equals(metaDescription, that.metaDescription) &&
        Objects.equals(metaKeywords, that.metaKeywords) &&
        Objects.equals(publish, that.publish) &&
        Objects.equals(variants, that.variants);
  }

  @Override
  public int hashCode() {
    return Objects.hash(product, name, key, description, slug, metaTitle, metaDescription, metaKeywords, publish, variants);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ResourceIdentifierInput product;

    private List<LocalizedStringItemInputType> name;

    private String key;

    private List<LocalizedStringItemInputType> description;

    private List<LocalizedStringItemInputType> slug;

    private List<LocalizedStringItemInputType> metaTitle;

    private List<LocalizedStringItemInputType> metaDescription;

    private List<LocalizedStringItemInputType> metaKeywords;

    private Boolean publish;

    private List<ProductVariantTailoringInput> variants = Collections.emptyList();

    public ProductTailoringDraft build() {
      ProductTailoringDraft result = new ProductTailoringDraft();
      result.product = this.product;
      result.name = this.name;
      result.key = this.key;
      result.description = this.description;
      result.slug = this.slug;
      result.metaTitle = this.metaTitle;
      result.metaDescription = this.metaDescription;
      result.metaKeywords = this.metaKeywords;
      result.publish = this.publish;
      result.variants = this.variants;
      return result;
    }

    public Builder product(ResourceIdentifierInput product) {
      this.product = product;
      return this;
    }

    public Builder name(List<LocalizedStringItemInputType> name) {
      this.name = name;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder description(List<LocalizedStringItemInputType> description) {
      this.description = description;
      return this;
    }

    public Builder slug(List<LocalizedStringItemInputType> slug) {
      this.slug = slug;
      return this;
    }

    public Builder metaTitle(List<LocalizedStringItemInputType> metaTitle) {
      this.metaTitle = metaTitle;
      return this;
    }

    public Builder metaDescription(List<LocalizedStringItemInputType> metaDescription) {
      this.metaDescription = metaDescription;
      return this;
    }

    public Builder metaKeywords(List<LocalizedStringItemInputType> metaKeywords) {
      this.metaKeywords = metaKeywords;
      return this;
    }

    public Builder publish(Boolean publish) {
      this.publish = publish;
      return this;
    }

    public Builder variants(List<ProductVariantTailoringInput> variants) {
      this.variants = variants;
      return this;
    }
  }
}
