package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoringImageAdded implements com.commercetools.graphql.api.types.MessagePayload {
  private Integer variantId;

  private KeyReference storeRef;

  private Reference productRef;

  private String productKey;

  private Image image;

  private String type;

  public ProductTailoringImageAdded() {
  }

  public ProductTailoringImageAdded(Integer variantId, KeyReference storeRef, Reference productRef,
      String productKey, Image image, String type) {
    this.variantId = variantId;
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.productKey = productKey;
    this.image = image;
    this.type = type;
  }

  public Integer getVariantId() {
    return variantId;
  }

  public void setVariantId(Integer variantId) {
    this.variantId = variantId;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public Image getImage() {
    return image;
  }

  public void setImage(Image image) {
    this.image = image;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductTailoringImageAdded{variantId='" + variantId + "', storeRef='" + storeRef + "', productRef='" + productRef + "', productKey='" + productKey + "', image='" + image + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringImageAdded that = (ProductTailoringImageAdded) o;
    return Objects.equals(variantId, that.variantId) &&
        Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(image, that.image) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(variantId, storeRef, productRef, productKey, image, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer variantId;

    private KeyReference storeRef;

    private Reference productRef;

    private String productKey;

    private Image image;

    private String type;

    public ProductTailoringImageAdded build() {
      ProductTailoringImageAdded result = new ProductTailoringImageAdded();
      result.variantId = this.variantId;
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.productKey = this.productKey;
      result.image = this.image;
      result.type = this.type;
      return result;
    }

    public Builder variantId(Integer variantId) {
      this.variantId = variantId;
      return this;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder image(Image image) {
      this.image = image;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
