package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductTailoringSlugSet implements com.commercetools.graphql.api.types.MessagePayload {
  private KeyReference storeRef;

  private Reference productRef;

  private String productKey;

  private String slug;

  private String oldSlug;

  private List<LocalizedString> slugAllLocales;

  private List<LocalizedString> oldSlugAllLocales;

  private String type;

  public ProductTailoringSlugSet() {
  }

  public ProductTailoringSlugSet(KeyReference storeRef, Reference productRef, String productKey,
      String slug, String oldSlug, List<LocalizedString> slugAllLocales,
      List<LocalizedString> oldSlugAllLocales, String type) {
    this.storeRef = storeRef;
    this.productRef = productRef;
    this.productKey = productKey;
    this.slug = slug;
    this.oldSlug = oldSlug;
    this.slugAllLocales = slugAllLocales;
    this.oldSlugAllLocales = oldSlugAllLocales;
    this.type = type;
  }

  public KeyReference getStoreRef() {
    return storeRef;
  }

  public void setStoreRef(KeyReference storeRef) {
    this.storeRef = storeRef;
  }

  public Reference getProductRef() {
    return productRef;
  }

  public void setProductRef(Reference productRef) {
    this.productRef = productRef;
  }

  public String getProductKey() {
    return productKey;
  }

  public void setProductKey(String productKey) {
    this.productKey = productKey;
  }

  public String getSlug() {
    return slug;
  }

  public void setSlug(String slug) {
    this.slug = slug;
  }

  public String getOldSlug() {
    return oldSlug;
  }

  public void setOldSlug(String oldSlug) {
    this.oldSlug = oldSlug;
  }

  public List<LocalizedString> getSlugAllLocales() {
    return slugAllLocales;
  }

  public void setSlugAllLocales(List<LocalizedString> slugAllLocales) {
    this.slugAllLocales = slugAllLocales;
  }

  public List<LocalizedString> getOldSlugAllLocales() {
    return oldSlugAllLocales;
  }

  public void setOldSlugAllLocales(List<LocalizedString> oldSlugAllLocales) {
    this.oldSlugAllLocales = oldSlugAllLocales;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductTailoringSlugSet{storeRef='" + storeRef + "', productRef='" + productRef + "', productKey='" + productKey + "', slug='" + slug + "', oldSlug='" + oldSlug + "', slugAllLocales='" + slugAllLocales + "', oldSlugAllLocales='" + oldSlugAllLocales + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringSlugSet that = (ProductTailoringSlugSet) o;
    return Objects.equals(storeRef, that.storeRef) &&
        Objects.equals(productRef, that.productRef) &&
        Objects.equals(productKey, that.productKey) &&
        Objects.equals(slug, that.slug) &&
        Objects.equals(oldSlug, that.oldSlug) &&
        Objects.equals(slugAllLocales, that.slugAllLocales) &&
        Objects.equals(oldSlugAllLocales, that.oldSlugAllLocales) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(storeRef, productRef, productKey, slug, oldSlug, slugAllLocales, oldSlugAllLocales, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private KeyReference storeRef;

    private Reference productRef;

    private String productKey;

    private String slug;

    private String oldSlug;

    private List<LocalizedString> slugAllLocales;

    private List<LocalizedString> oldSlugAllLocales;

    private String type;

    public ProductTailoringSlugSet build() {
      ProductTailoringSlugSet result = new ProductTailoringSlugSet();
      result.storeRef = this.storeRef;
      result.productRef = this.productRef;
      result.productKey = this.productKey;
      result.slug = this.slug;
      result.oldSlug = this.oldSlug;
      result.slugAllLocales = this.slugAllLocales;
      result.oldSlugAllLocales = this.oldSlugAllLocales;
      result.type = this.type;
      return result;
    }

    public Builder storeRef(KeyReference storeRef) {
      this.storeRef = storeRef;
      return this;
    }

    public Builder productRef(Reference productRef) {
      this.productRef = productRef;
      return this;
    }

    public Builder productKey(String productKey) {
      this.productKey = productKey;
      return this;
    }

    public Builder slug(String slug) {
      this.slug = slug;
      return this;
    }

    public Builder oldSlug(String oldSlug) {
      this.oldSlug = oldSlug;
      return this;
    }

    public Builder slugAllLocales(List<LocalizedString> slugAllLocales) {
      this.slugAllLocales = slugAllLocales;
      return this;
    }

    public Builder oldSlugAllLocales(List<LocalizedString> oldSlugAllLocales) {
      this.oldSlugAllLocales = oldSlugAllLocales;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
