package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductTailoringUpdateAction {
  private MoveProductTailoringImageToPosition moveImageToPosition;

  private AddProductVariantTailoring addVariant;

  private RemoveProductVariantTailoring removeVariant;

  private PublishTailoring publish;

  private UnpublishTailoring unpublish;

  private AddProductTailoringAsset addAsset;

  private AddProductTailoringExternalImage addExternalImage;

  private ChangeProductTailoringAssetName changeAssetName;

  private ChangeProductTailoringAssetOrder changeAssetOrder;

  private RemoveProductTailoringAsset removeAsset;

  private RemoveProductTailoringImage removeImage;

  private SetProductTailoringAssetCustomField setAssetCustomField;

  private SetProductTailoringAssetCustomType setAssetCustomType;

  private SetProductTailoringAssetDescription setAssetDescription;

  private SetProductTailoringAssetKey setAssetKey;

  private SetProductTailoringAssetSources setAssetSources;

  private SetProductTailoringAssetTags setAssetTags;

  private SetProductTailoringImages setImages;

  private SetProductTailoringDescription setDescription;

  private SetProductTailoringAttribute setAttribute;

  private SetProductTailoringAttributeInAllVariants setAttributeInAllVariants;

  private SetProductTailoringImageLabel setImageLabel;

  private SetProductTailoringMetaAttributes setMetaAttributes;

  private SetProductTailoringMetaDescription setMetaDescription;

  private SetProductTailoringMetaKeywords setMetaKeywords;

  private SetProductTailoringMetaTitle setMetaTitle;

  private SetProductTailoringName setName;

  private SetProductTailoringSlug setSlug;

  public ProductTailoringUpdateAction() {
  }

  public ProductTailoringUpdateAction(MoveProductTailoringImageToPosition moveImageToPosition,
      AddProductVariantTailoring addVariant, RemoveProductVariantTailoring removeVariant,
      PublishTailoring publish, UnpublishTailoring unpublish, AddProductTailoringAsset addAsset,
      AddProductTailoringExternalImage addExternalImage,
      ChangeProductTailoringAssetName changeAssetName,
      ChangeProductTailoringAssetOrder changeAssetOrder, RemoveProductTailoringAsset removeAsset,
      RemoveProductTailoringImage removeImage,
      SetProductTailoringAssetCustomField setAssetCustomField,
      SetProductTailoringAssetCustomType setAssetCustomType,
      SetProductTailoringAssetDescription setAssetDescription,
      SetProductTailoringAssetKey setAssetKey, SetProductTailoringAssetSources setAssetSources,
      SetProductTailoringAssetTags setAssetTags, SetProductTailoringImages setImages,
      SetProductTailoringDescription setDescription, SetProductTailoringAttribute setAttribute,
      SetProductTailoringAttributeInAllVariants setAttributeInAllVariants,
      SetProductTailoringImageLabel setImageLabel,
      SetProductTailoringMetaAttributes setMetaAttributes,
      SetProductTailoringMetaDescription setMetaDescription,
      SetProductTailoringMetaKeywords setMetaKeywords, SetProductTailoringMetaTitle setMetaTitle,
      SetProductTailoringName setName, SetProductTailoringSlug setSlug) {
    this.moveImageToPosition = moveImageToPosition;
    this.addVariant = addVariant;
    this.removeVariant = removeVariant;
    this.publish = publish;
    this.unpublish = unpublish;
    this.addAsset = addAsset;
    this.addExternalImage = addExternalImage;
    this.changeAssetName = changeAssetName;
    this.changeAssetOrder = changeAssetOrder;
    this.removeAsset = removeAsset;
    this.removeImage = removeImage;
    this.setAssetCustomField = setAssetCustomField;
    this.setAssetCustomType = setAssetCustomType;
    this.setAssetDescription = setAssetDescription;
    this.setAssetKey = setAssetKey;
    this.setAssetSources = setAssetSources;
    this.setAssetTags = setAssetTags;
    this.setImages = setImages;
    this.setDescription = setDescription;
    this.setAttribute = setAttribute;
    this.setAttributeInAllVariants = setAttributeInAllVariants;
    this.setImageLabel = setImageLabel;
    this.setMetaAttributes = setMetaAttributes;
    this.setMetaDescription = setMetaDescription;
    this.setMetaKeywords = setMetaKeywords;
    this.setMetaTitle = setMetaTitle;
    this.setName = setName;
    this.setSlug = setSlug;
  }

  public MoveProductTailoringImageToPosition getMoveImageToPosition() {
    return moveImageToPosition;
  }

  public void setMoveImageToPosition(MoveProductTailoringImageToPosition moveImageToPosition) {
    this.moveImageToPosition = moveImageToPosition;
  }

  public AddProductVariantTailoring getAddVariant() {
    return addVariant;
  }

  public void setAddVariant(AddProductVariantTailoring addVariant) {
    this.addVariant = addVariant;
  }

  public RemoveProductVariantTailoring getRemoveVariant() {
    return removeVariant;
  }

  public void setRemoveVariant(RemoveProductVariantTailoring removeVariant) {
    this.removeVariant = removeVariant;
  }

  public PublishTailoring getPublish() {
    return publish;
  }

  public void setPublish(PublishTailoring publish) {
    this.publish = publish;
  }

  public UnpublishTailoring getUnpublish() {
    return unpublish;
  }

  public void setUnpublish(UnpublishTailoring unpublish) {
    this.unpublish = unpublish;
  }

  public AddProductTailoringAsset getAddAsset() {
    return addAsset;
  }

  public void setAddAsset(AddProductTailoringAsset addAsset) {
    this.addAsset = addAsset;
  }

  public AddProductTailoringExternalImage getAddExternalImage() {
    return addExternalImage;
  }

  public void setAddExternalImage(AddProductTailoringExternalImage addExternalImage) {
    this.addExternalImage = addExternalImage;
  }

  public ChangeProductTailoringAssetName getChangeAssetName() {
    return changeAssetName;
  }

  public void setChangeAssetName(ChangeProductTailoringAssetName changeAssetName) {
    this.changeAssetName = changeAssetName;
  }

  public ChangeProductTailoringAssetOrder getChangeAssetOrder() {
    return changeAssetOrder;
  }

  public void setChangeAssetOrder(ChangeProductTailoringAssetOrder changeAssetOrder) {
    this.changeAssetOrder = changeAssetOrder;
  }

  public RemoveProductTailoringAsset getRemoveAsset() {
    return removeAsset;
  }

  public void setRemoveAsset(RemoveProductTailoringAsset removeAsset) {
    this.removeAsset = removeAsset;
  }

  public RemoveProductTailoringImage getRemoveImage() {
    return removeImage;
  }

  public void setRemoveImage(RemoveProductTailoringImage removeImage) {
    this.removeImage = removeImage;
  }

  public SetProductTailoringAssetCustomField getSetAssetCustomField() {
    return setAssetCustomField;
  }

  public void setSetAssetCustomField(SetProductTailoringAssetCustomField setAssetCustomField) {
    this.setAssetCustomField = setAssetCustomField;
  }

  public SetProductTailoringAssetCustomType getSetAssetCustomType() {
    return setAssetCustomType;
  }

  public void setSetAssetCustomType(SetProductTailoringAssetCustomType setAssetCustomType) {
    this.setAssetCustomType = setAssetCustomType;
  }

  public SetProductTailoringAssetDescription getSetAssetDescription() {
    return setAssetDescription;
  }

  public void setSetAssetDescription(SetProductTailoringAssetDescription setAssetDescription) {
    this.setAssetDescription = setAssetDescription;
  }

  public SetProductTailoringAssetKey getSetAssetKey() {
    return setAssetKey;
  }

  public void setSetAssetKey(SetProductTailoringAssetKey setAssetKey) {
    this.setAssetKey = setAssetKey;
  }

  public SetProductTailoringAssetSources getSetAssetSources() {
    return setAssetSources;
  }

  public void setSetAssetSources(SetProductTailoringAssetSources setAssetSources) {
    this.setAssetSources = setAssetSources;
  }

  public SetProductTailoringAssetTags getSetAssetTags() {
    return setAssetTags;
  }

  public void setSetAssetTags(SetProductTailoringAssetTags setAssetTags) {
    this.setAssetTags = setAssetTags;
  }

  public SetProductTailoringImages getSetImages() {
    return setImages;
  }

  public void setSetImages(SetProductTailoringImages setImages) {
    this.setImages = setImages;
  }

  public SetProductTailoringDescription getSetDescription() {
    return setDescription;
  }

  public void setSetDescription(SetProductTailoringDescription setDescription) {
    this.setDescription = setDescription;
  }

  public SetProductTailoringAttribute getSetAttribute() {
    return setAttribute;
  }

  public void setSetAttribute(SetProductTailoringAttribute setAttribute) {
    this.setAttribute = setAttribute;
  }

  public SetProductTailoringAttributeInAllVariants getSetAttributeInAllVariants() {
    return setAttributeInAllVariants;
  }

  public void setSetAttributeInAllVariants(
      SetProductTailoringAttributeInAllVariants setAttributeInAllVariants) {
    this.setAttributeInAllVariants = setAttributeInAllVariants;
  }

  public SetProductTailoringImageLabel getSetImageLabel() {
    return setImageLabel;
  }

  public void setSetImageLabel(SetProductTailoringImageLabel setImageLabel) {
    this.setImageLabel = setImageLabel;
  }

  public SetProductTailoringMetaAttributes getSetMetaAttributes() {
    return setMetaAttributes;
  }

  public void setSetMetaAttributes(SetProductTailoringMetaAttributes setMetaAttributes) {
    this.setMetaAttributes = setMetaAttributes;
  }

  public SetProductTailoringMetaDescription getSetMetaDescription() {
    return setMetaDescription;
  }

  public void setSetMetaDescription(SetProductTailoringMetaDescription setMetaDescription) {
    this.setMetaDescription = setMetaDescription;
  }

  public SetProductTailoringMetaKeywords getSetMetaKeywords() {
    return setMetaKeywords;
  }

  public void setSetMetaKeywords(SetProductTailoringMetaKeywords setMetaKeywords) {
    this.setMetaKeywords = setMetaKeywords;
  }

  public SetProductTailoringMetaTitle getSetMetaTitle() {
    return setMetaTitle;
  }

  public void setSetMetaTitle(SetProductTailoringMetaTitle setMetaTitle) {
    this.setMetaTitle = setMetaTitle;
  }

  public SetProductTailoringName getSetName() {
    return setName;
  }

  public void setSetName(SetProductTailoringName setName) {
    this.setName = setName;
  }

  public SetProductTailoringSlug getSetSlug() {
    return setSlug;
  }

  public void setSetSlug(SetProductTailoringSlug setSlug) {
    this.setSlug = setSlug;
  }

  @Override
  public String toString() {
    return "ProductTailoringUpdateAction{moveImageToPosition='" + moveImageToPosition + "', addVariant='" + addVariant + "', removeVariant='" + removeVariant + "', publish='" + publish + "', unpublish='" + unpublish + "', addAsset='" + addAsset + "', addExternalImage='" + addExternalImage + "', changeAssetName='" + changeAssetName + "', changeAssetOrder='" + changeAssetOrder + "', removeAsset='" + removeAsset + "', removeImage='" + removeImage + "', setAssetCustomField='" + setAssetCustomField + "', setAssetCustomType='" + setAssetCustomType + "', setAssetDescription='" + setAssetDescription + "', setAssetKey='" + setAssetKey + "', setAssetSources='" + setAssetSources + "', setAssetTags='" + setAssetTags + "', setImages='" + setImages + "', setDescription='" + setDescription + "', setAttribute='" + setAttribute + "', setAttributeInAllVariants='" + setAttributeInAllVariants + "', setImageLabel='" + setImageLabel + "', setMetaAttributes='" + setMetaAttributes + "', setMetaDescription='" + setMetaDescription + "', setMetaKeywords='" + setMetaKeywords + "', setMetaTitle='" + setMetaTitle + "', setName='" + setName + "', setSlug='" + setSlug + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTailoringUpdateAction that = (ProductTailoringUpdateAction) o;
    return Objects.equals(moveImageToPosition, that.moveImageToPosition) &&
        Objects.equals(addVariant, that.addVariant) &&
        Objects.equals(removeVariant, that.removeVariant) &&
        Objects.equals(publish, that.publish) &&
        Objects.equals(unpublish, that.unpublish) &&
        Objects.equals(addAsset, that.addAsset) &&
        Objects.equals(addExternalImage, that.addExternalImage) &&
        Objects.equals(changeAssetName, that.changeAssetName) &&
        Objects.equals(changeAssetOrder, that.changeAssetOrder) &&
        Objects.equals(removeAsset, that.removeAsset) &&
        Objects.equals(removeImage, that.removeImage) &&
        Objects.equals(setAssetCustomField, that.setAssetCustomField) &&
        Objects.equals(setAssetCustomType, that.setAssetCustomType) &&
        Objects.equals(setAssetDescription, that.setAssetDescription) &&
        Objects.equals(setAssetKey, that.setAssetKey) &&
        Objects.equals(setAssetSources, that.setAssetSources) &&
        Objects.equals(setAssetTags, that.setAssetTags) &&
        Objects.equals(setImages, that.setImages) &&
        Objects.equals(setDescription, that.setDescription) &&
        Objects.equals(setAttribute, that.setAttribute) &&
        Objects.equals(setAttributeInAllVariants, that.setAttributeInAllVariants) &&
        Objects.equals(setImageLabel, that.setImageLabel) &&
        Objects.equals(setMetaAttributes, that.setMetaAttributes) &&
        Objects.equals(setMetaDescription, that.setMetaDescription) &&
        Objects.equals(setMetaKeywords, that.setMetaKeywords) &&
        Objects.equals(setMetaTitle, that.setMetaTitle) &&
        Objects.equals(setName, that.setName) &&
        Objects.equals(setSlug, that.setSlug);
  }

  @Override
  public int hashCode() {
    return Objects.hash(moveImageToPosition, addVariant, removeVariant, publish, unpublish, addAsset, addExternalImage, changeAssetName, changeAssetOrder, removeAsset, removeImage, setAssetCustomField, setAssetCustomType, setAssetDescription, setAssetKey, setAssetSources, setAssetTags, setImages, setDescription, setAttribute, setAttributeInAllVariants, setImageLabel, setMetaAttributes, setMetaDescription, setMetaKeywords, setMetaTitle, setName, setSlug);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private MoveProductTailoringImageToPosition moveImageToPosition;

    private AddProductVariantTailoring addVariant;

    private RemoveProductVariantTailoring removeVariant;

    private PublishTailoring publish;

    private UnpublishTailoring unpublish;

    private AddProductTailoringAsset addAsset;

    private AddProductTailoringExternalImage addExternalImage;

    private ChangeProductTailoringAssetName changeAssetName;

    private ChangeProductTailoringAssetOrder changeAssetOrder;

    private RemoveProductTailoringAsset removeAsset;

    private RemoveProductTailoringImage removeImage;

    private SetProductTailoringAssetCustomField setAssetCustomField;

    private SetProductTailoringAssetCustomType setAssetCustomType;

    private SetProductTailoringAssetDescription setAssetDescription;

    private SetProductTailoringAssetKey setAssetKey;

    private SetProductTailoringAssetSources setAssetSources;

    private SetProductTailoringAssetTags setAssetTags;

    private SetProductTailoringImages setImages;

    private SetProductTailoringDescription setDescription;

    private SetProductTailoringAttribute setAttribute;

    private SetProductTailoringAttributeInAllVariants setAttributeInAllVariants;

    private SetProductTailoringImageLabel setImageLabel;

    private SetProductTailoringMetaAttributes setMetaAttributes;

    private SetProductTailoringMetaDescription setMetaDescription;

    private SetProductTailoringMetaKeywords setMetaKeywords;

    private SetProductTailoringMetaTitle setMetaTitle;

    private SetProductTailoringName setName;

    private SetProductTailoringSlug setSlug;

    public ProductTailoringUpdateAction build() {
      ProductTailoringUpdateAction result = new ProductTailoringUpdateAction();
      result.moveImageToPosition = this.moveImageToPosition;
      result.addVariant = this.addVariant;
      result.removeVariant = this.removeVariant;
      result.publish = this.publish;
      result.unpublish = this.unpublish;
      result.addAsset = this.addAsset;
      result.addExternalImage = this.addExternalImage;
      result.changeAssetName = this.changeAssetName;
      result.changeAssetOrder = this.changeAssetOrder;
      result.removeAsset = this.removeAsset;
      result.removeImage = this.removeImage;
      result.setAssetCustomField = this.setAssetCustomField;
      result.setAssetCustomType = this.setAssetCustomType;
      result.setAssetDescription = this.setAssetDescription;
      result.setAssetKey = this.setAssetKey;
      result.setAssetSources = this.setAssetSources;
      result.setAssetTags = this.setAssetTags;
      result.setImages = this.setImages;
      result.setDescription = this.setDescription;
      result.setAttribute = this.setAttribute;
      result.setAttributeInAllVariants = this.setAttributeInAllVariants;
      result.setImageLabel = this.setImageLabel;
      result.setMetaAttributes = this.setMetaAttributes;
      result.setMetaDescription = this.setMetaDescription;
      result.setMetaKeywords = this.setMetaKeywords;
      result.setMetaTitle = this.setMetaTitle;
      result.setName = this.setName;
      result.setSlug = this.setSlug;
      return result;
    }

    public Builder moveImageToPosition(MoveProductTailoringImageToPosition moveImageToPosition) {
      this.moveImageToPosition = moveImageToPosition;
      return this;
    }

    public Builder addVariant(AddProductVariantTailoring addVariant) {
      this.addVariant = addVariant;
      return this;
    }

    public Builder removeVariant(RemoveProductVariantTailoring removeVariant) {
      this.removeVariant = removeVariant;
      return this;
    }

    public Builder publish(PublishTailoring publish) {
      this.publish = publish;
      return this;
    }

    public Builder unpublish(UnpublishTailoring unpublish) {
      this.unpublish = unpublish;
      return this;
    }

    public Builder addAsset(AddProductTailoringAsset addAsset) {
      this.addAsset = addAsset;
      return this;
    }

    public Builder addExternalImage(AddProductTailoringExternalImage addExternalImage) {
      this.addExternalImage = addExternalImage;
      return this;
    }

    public Builder changeAssetName(ChangeProductTailoringAssetName changeAssetName) {
      this.changeAssetName = changeAssetName;
      return this;
    }

    public Builder changeAssetOrder(ChangeProductTailoringAssetOrder changeAssetOrder) {
      this.changeAssetOrder = changeAssetOrder;
      return this;
    }

    public Builder removeAsset(RemoveProductTailoringAsset removeAsset) {
      this.removeAsset = removeAsset;
      return this;
    }

    public Builder removeImage(RemoveProductTailoringImage removeImage) {
      this.removeImage = removeImage;
      return this;
    }

    public Builder setAssetCustomField(SetProductTailoringAssetCustomField setAssetCustomField) {
      this.setAssetCustomField = setAssetCustomField;
      return this;
    }

    public Builder setAssetCustomType(SetProductTailoringAssetCustomType setAssetCustomType) {
      this.setAssetCustomType = setAssetCustomType;
      return this;
    }

    public Builder setAssetDescription(SetProductTailoringAssetDescription setAssetDescription) {
      this.setAssetDescription = setAssetDescription;
      return this;
    }

    public Builder setAssetKey(SetProductTailoringAssetKey setAssetKey) {
      this.setAssetKey = setAssetKey;
      return this;
    }

    public Builder setAssetSources(SetProductTailoringAssetSources setAssetSources) {
      this.setAssetSources = setAssetSources;
      return this;
    }

    public Builder setAssetTags(SetProductTailoringAssetTags setAssetTags) {
      this.setAssetTags = setAssetTags;
      return this;
    }

    public Builder setImages(SetProductTailoringImages setImages) {
      this.setImages = setImages;
      return this;
    }

    public Builder setDescription(SetProductTailoringDescription setDescription) {
      this.setDescription = setDescription;
      return this;
    }

    public Builder setAttribute(SetProductTailoringAttribute setAttribute) {
      this.setAttribute = setAttribute;
      return this;
    }

    public Builder setAttributeInAllVariants(
        SetProductTailoringAttributeInAllVariants setAttributeInAllVariants) {
      this.setAttributeInAllVariants = setAttributeInAllVariants;
      return this;
    }

    public Builder setImageLabel(SetProductTailoringImageLabel setImageLabel) {
      this.setImageLabel = setImageLabel;
      return this;
    }

    public Builder setMetaAttributes(SetProductTailoringMetaAttributes setMetaAttributes) {
      this.setMetaAttributes = setMetaAttributes;
      return this;
    }

    public Builder setMetaDescription(SetProductTailoringMetaDescription setMetaDescription) {
      this.setMetaDescription = setMetaDescription;
      return this;
    }

    public Builder setMetaKeywords(SetProductTailoringMetaKeywords setMetaKeywords) {
      this.setMetaKeywords = setMetaKeywords;
      return this;
    }

    public Builder setMetaTitle(SetProductTailoringMetaTitle setMetaTitle) {
      this.setMetaTitle = setMetaTitle;
      return this;
    }

    public Builder setName(SetProductTailoringName setName) {
      this.setName = setName;
      return this;
    }

    public Builder setSlug(SetProductTailoringSlug setSlug) {
      this.setSlug = setSlug;
      return this;
    }
  }
}
