package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductTypeDraft {
  private String name;

  private String description;

  private String key;

  private List<AttributeDefinitionDraft> attributeDefinitions;

  public ProductTypeDraft() {
  }

  public ProductTypeDraft(String name, String description, String key,
      List<AttributeDefinitionDraft> attributeDefinitions) {
    this.name = name;
    this.description = description;
    this.key = key;
    this.attributeDefinitions = attributeDefinitions;
  }

  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<AttributeDefinitionDraft> getAttributeDefinitions() {
    return attributeDefinitions;
  }

  public void setAttributeDefinitions(List<AttributeDefinitionDraft> attributeDefinitions) {
    this.attributeDefinitions = attributeDefinitions;
  }

  @Override
  public String toString() {
    return "ProductTypeDraft{name='" + name + "', description='" + description + "', key='" + key + "', attributeDefinitions='" + attributeDefinitions + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTypeDraft that = (ProductTypeDraft) o;
    return Objects.equals(name, that.name) &&
        Objects.equals(description, that.description) &&
        Objects.equals(key, that.key) &&
        Objects.equals(attributeDefinitions, that.attributeDefinitions);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, description, key, attributeDefinitions);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String name;

    private String description;

    private String key;

    private List<AttributeDefinitionDraft> attributeDefinitions;

    public ProductTypeDraft build() {
      ProductTypeDraft result = new ProductTypeDraft();
      result.name = this.name;
      result.description = this.description;
      result.key = this.key;
      result.attributeDefinitions = this.attributeDefinitions;
      return result;
    }

    public Builder name(String name) {
      this.name = name;
      return this;
    }

    public Builder description(String description) {
      this.description = description;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder attributeDefinitions(List<AttributeDefinitionDraft> attributeDefinitions) {
      this.attributeDefinitions = attributeDefinitions;
      return this;
    }
  }
}
