package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductTypeLimitsProjection {
  private ProductTypeLimitWithCurrent total;

  public ProductTypeLimitsProjection() {
  }

  public ProductTypeLimitsProjection(ProductTypeLimitWithCurrent total) {
    this.total = total;
  }

  public ProductTypeLimitWithCurrent getTotal() {
    return total;
  }

  public void setTotal(ProductTypeLimitWithCurrent total) {
    this.total = total;
  }

  @Override
  public String toString() {
    return "ProductTypeLimitsProjection{total='" + total + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductTypeLimitsProjection that = (ProductTypeLimitsProjection) o;
    return Objects.equals(total, that.total);
  }

  @Override
  public int hashCode() {
    return Objects.hash(total);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ProductTypeLimitWithCurrent total;

    public ProductTypeLimitsProjection build() {
      ProductTypeLimitsProjection result = new ProductTypeLimitsProjection();
      result.total = this.total;
      return result;
    }

    public Builder total(ProductTypeLimitWithCurrent total) {
      this.total = total;
      return this;
    }
  }
}
