package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductUnpublished implements com.commercetools.graphql.api.types.MessagePayload {
  private String type;

  public ProductUnpublished() {
  }

  public ProductUnpublished(String type) {
    this.type = type;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductUnpublished{type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductUnpublished that = (ProductUnpublished) o;
    return Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    public ProductUnpublished build() {
      ProductUnpublished result = new ProductUnpublished();
      result.type = this.type;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
