package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductVariant {
  private Integer id;

  private String key;

  private String sku;

  private List<ProductPrice> prices;

  /**
   * Returns a single price based on the price selection rules.
   */
  private ProductPrice price;

  private List<Image> images;

  private List<Asset> assets;

  private ProductVariantAvailabilityWithChannels availability;

  /**
   * This field contains raw attributes data
   */
  private List<RawProductAttribute> attributesRaw;

  public ProductVariant() {
  }

  public ProductVariant(Integer id, String key, String sku, List<ProductPrice> prices,
      ProductPrice price, List<Image> images, List<Asset> assets,
      ProductVariantAvailabilityWithChannels availability,
      List<RawProductAttribute> attributesRaw) {
    this.id = id;
    this.key = key;
    this.sku = sku;
    this.prices = prices;
    this.price = price;
    this.images = images;
    this.assets = assets;
    this.availability = availability;
    this.attributesRaw = attributesRaw;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public List<ProductPrice> getPrices() {
    return prices;
  }

  public void setPrices(List<ProductPrice> prices) {
    this.prices = prices;
  }

  /**
   * Returns a single price based on the price selection rules.
   */
  public ProductPrice getPrice() {
    return price;
  }

  public void setPrice(ProductPrice price) {
    this.price = price;
  }

  public List<Image> getImages() {
    return images;
  }

  public void setImages(List<Image> images) {
    this.images = images;
  }

  public List<Asset> getAssets() {
    return assets;
  }

  public void setAssets(List<Asset> assets) {
    this.assets = assets;
  }

  public ProductVariantAvailabilityWithChannels getAvailability() {
    return availability;
  }

  public void setAvailability(ProductVariantAvailabilityWithChannels availability) {
    this.availability = availability;
  }

  /**
   * This field contains raw attributes data
   */
  public List<RawProductAttribute> getAttributesRaw() {
    return attributesRaw;
  }

  public void setAttributesRaw(List<RawProductAttribute> attributesRaw) {
    this.attributesRaw = attributesRaw;
  }

  @Override
  public String toString() {
    return "ProductVariant{id='" + id + "', key='" + key + "', sku='" + sku + "', prices='" + prices + "', price='" + price + "', images='" + images + "', assets='" + assets + "', availability='" + availability + "', attributesRaw='" + attributesRaw + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariant that = (ProductVariant) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(key, that.key) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(prices, that.prices) &&
        Objects.equals(price, that.price) &&
        Objects.equals(images, that.images) &&
        Objects.equals(assets, that.assets) &&
        Objects.equals(availability, that.availability) &&
        Objects.equals(attributesRaw, that.attributesRaw);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, key, sku, prices, price, images, assets, availability, attributesRaw);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer id;

    private String key;

    private String sku;

    private List<ProductPrice> prices;

    /**
     * Returns a single price based on the price selection rules.
     */
    private ProductPrice price;

    private List<Image> images;

    private List<Asset> assets;

    private ProductVariantAvailabilityWithChannels availability;

    /**
     * This field contains raw attributes data
     */
    private List<RawProductAttribute> attributesRaw;

    public ProductVariant build() {
      ProductVariant result = new ProductVariant();
      result.id = this.id;
      result.key = this.key;
      result.sku = this.sku;
      result.prices = this.prices;
      result.price = this.price;
      result.images = this.images;
      result.assets = this.assets;
      result.availability = this.availability;
      result.attributesRaw = this.attributesRaw;
      return result;
    }

    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder prices(List<ProductPrice> prices) {
      this.prices = prices;
      return this;
    }

    /**
     * Returns a single price based on the price selection rules.
     */
    public Builder price(ProductPrice price) {
      this.price = price;
      return this;
    }

    public Builder images(List<Image> images) {
      this.images = images;
      return this;
    }

    public Builder assets(List<Asset> assets) {
      this.assets = assets;
      return this;
    }

    public Builder availability(ProductVariantAvailabilityWithChannels availability) {
      this.availability = availability;
      return this;
    }

    /**
     * This field contains raw attributes data
     */
    public Builder attributesRaw(List<RawProductAttribute> attributesRaw) {
      this.attributesRaw = attributesRaw;
      return this;
    }
  }
}
