package com.commercetools.graphql.api.types;

import java.lang.Boolean;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

/**
 * Product variant availability
 */
public class ProductVariantAvailability {
  private Boolean isOnStock;

  private Integer restockableInDays;

  private Long availableQuantity;

  private Long version;

  private String id;

  public ProductVariantAvailability() {
  }

  public ProductVariantAvailability(Boolean isOnStock, Integer restockableInDays,
      Long availableQuantity, Long version, String id) {
    this.isOnStock = isOnStock;
    this.restockableInDays = restockableInDays;
    this.availableQuantity = availableQuantity;
    this.version = version;
    this.id = id;
  }

  public Boolean getIsOnStock() {
    return isOnStock;
  }

  public void setIsOnStock(Boolean isOnStock) {
    this.isOnStock = isOnStock;
  }

  public Integer getRestockableInDays() {
    return restockableInDays;
  }

  public void setRestockableInDays(Integer restockableInDays) {
    this.restockableInDays = restockableInDays;
  }

  public Long getAvailableQuantity() {
    return availableQuantity;
  }

  public void setAvailableQuantity(Long availableQuantity) {
    this.availableQuantity = availableQuantity;
  }

  public Long getVersion() {
    return version;
  }

  public void setVersion(Long version) {
    this.version = version;
  }

  public String getId() {
    return id;
  }

  public void setId(String id) {
    this.id = id;
  }

  @Override
  public String toString() {
    return "ProductVariantAvailability{isOnStock='" + isOnStock + "', restockableInDays='" + restockableInDays + "', availableQuantity='" + availableQuantity + "', version='" + version + "', id='" + id + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantAvailability that = (ProductVariantAvailability) o;
    return Objects.equals(isOnStock, that.isOnStock) &&
        Objects.equals(restockableInDays, that.restockableInDays) &&
        Objects.equals(availableQuantity, that.availableQuantity) &&
        Objects.equals(version, that.version) &&
        Objects.equals(id, that.id);
  }

  @Override
  public int hashCode() {
    return Objects.hash(isOnStock, restockableInDays, availableQuantity, version, id);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Boolean isOnStock;

    private Integer restockableInDays;

    private Long availableQuantity;

    private Long version;

    private String id;

    public ProductVariantAvailability build() {
      ProductVariantAvailability result = new ProductVariantAvailability();
      result.isOnStock = this.isOnStock;
      result.restockableInDays = this.restockableInDays;
      result.availableQuantity = this.availableQuantity;
      result.version = this.version;
      result.id = this.id;
      return result;
    }

    public Builder isOnStock(Boolean isOnStock) {
      this.isOnStock = isOnStock;
      return this;
    }

    public Builder restockableInDays(Integer restockableInDays) {
      this.restockableInDays = restockableInDays;
      return this;
    }

    public Builder availableQuantity(Long availableQuantity) {
      this.availableQuantity = availableQuantity;
      return this;
    }

    public Builder version(Long version) {
      this.version = version;
      return this;
    }

    public Builder id(String id) {
      this.id = id;
      return this;
    }
  }
}
