package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProductVariantAvailabilityWithChannel {
  private Reference channelRef;

  private Channel channel;

  private ProductVariantAvailability availability;

  public ProductVariantAvailabilityWithChannel() {
  }

  public ProductVariantAvailabilityWithChannel(Reference channelRef, Channel channel,
      ProductVariantAvailability availability) {
    this.channelRef = channelRef;
    this.channel = channel;
    this.availability = availability;
  }

  public Reference getChannelRef() {
    return channelRef;
  }

  public void setChannelRef(Reference channelRef) {
    this.channelRef = channelRef;
  }

  public Channel getChannel() {
    return channel;
  }

  public void setChannel(Channel channel) {
    this.channel = channel;
  }

  public ProductVariantAvailability getAvailability() {
    return availability;
  }

  public void setAvailability(ProductVariantAvailability availability) {
    this.availability = availability;
  }

  @Override
  public String toString() {
    return "ProductVariantAvailabilityWithChannel{channelRef='" + channelRef + "', channel='" + channel + "', availability='" + availability + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantAvailabilityWithChannel that = (ProductVariantAvailabilityWithChannel) o;
    return Objects.equals(channelRef, that.channelRef) &&
        Objects.equals(channel, that.channel) &&
        Objects.equals(availability, that.availability);
  }

  @Override
  public int hashCode() {
    return Objects.hash(channelRef, channel, availability);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Reference channelRef;

    private Channel channel;

    private ProductVariantAvailability availability;

    public ProductVariantAvailabilityWithChannel build() {
      ProductVariantAvailabilityWithChannel result = new ProductVariantAvailabilityWithChannel();
      result.channelRef = this.channelRef;
      result.channel = this.channel;
      result.availability = this.availability;
      return result;
    }

    public Builder channelRef(Reference channelRef) {
      this.channelRef = channelRef;
      return this;
    }

    public Builder channel(Channel channel) {
      this.channel = channel;
      return this;
    }

    public Builder availability(ProductVariantAvailability availability) {
      this.availability = availability;
      return this;
    }
  }
}
