package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Boolean;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductVariantDeleted implements com.commercetools.graphql.api.types.MessagePayload {
  private Object removedImageUrls;

  private ProductVariant variant;

  private Boolean staged;

  private String type;

  public ProductVariantDeleted() {
  }

  public ProductVariantDeleted(Object removedImageUrls, ProductVariant variant, Boolean staged,
      String type) {
    this.removedImageUrls = removedImageUrls;
    this.variant = variant;
    this.staged = staged;
    this.type = type;
  }

  public Object getRemovedImageUrls() {
    return removedImageUrls;
  }

  public void setRemovedImageUrls(Object removedImageUrls) {
    this.removedImageUrls = removedImageUrls;
  }

  public ProductVariant getVariant() {
    return variant;
  }

  public void setVariant(ProductVariant variant) {
    this.variant = variant;
  }

  public Boolean getStaged() {
    return staged;
  }

  public void setStaged(Boolean staged) {
    this.staged = staged;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  @Override
  public String toString() {
    return "ProductVariantDeleted{removedImageUrls='" + removedImageUrls + "', variant='" + variant + "', staged='" + staged + "', type='" + type + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantDeleted that = (ProductVariantDeleted) o;
    return Objects.equals(removedImageUrls, that.removedImageUrls) &&
        Objects.equals(variant, that.variant) &&
        Objects.equals(staged, that.staged) &&
        Objects.equals(type, that.type);
  }

  @Override
  public int hashCode() {
    return Objects.hash(removedImageUrls, variant, staged, type);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Object removedImageUrls;

    private ProductVariant variant;

    private Boolean staged;

    private String type;

    public ProductVariantDeleted build() {
      ProductVariantDeleted result = new ProductVariantDeleted();
      result.removedImageUrls = this.removedImageUrls;
      result.variant = this.variant;
      result.staged = this.staged;
      result.type = this.type;
      return result;
    }

    public Builder removedImageUrls(Object removedImageUrls) {
      this.removedImageUrls = removedImageUrls;
      return this;
    }

    public Builder variant(ProductVariant variant) {
      this.variant = variant;
      return this;
    }

    public Builder staged(Boolean staged) {
      this.staged = staged;
      return this;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }
  }
}
