package com.commercetools.graphql.api.types;

import java.lang.Integer;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductVariantImportDraft {
  private Integer id;

  private String sku;

  private List<ProductPriceDataInput> prices = Collections.emptyList();

  private List<ImageInput> images = Collections.emptyList();

  private List<ProductAttributeInput> attributes = Collections.emptyList();

  public ProductVariantImportDraft() {
  }

  public ProductVariantImportDraft(Integer id, String sku, List<ProductPriceDataInput> prices,
      List<ImageInput> images, List<ProductAttributeInput> attributes) {
    this.id = id;
    this.sku = sku;
    this.prices = prices;
    this.images = images;
    this.attributes = attributes;
  }

  public Integer getId() {
    return id;
  }

  public void setId(Integer id) {
    this.id = id;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public List<ProductPriceDataInput> getPrices() {
    return prices;
  }

  public void setPrices(List<ProductPriceDataInput> prices) {
    this.prices = prices;
  }

  public List<ImageInput> getImages() {
    return images;
  }

  public void setImages(List<ImageInput> images) {
    this.images = images;
  }

  public List<ProductAttributeInput> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<ProductAttributeInput> attributes) {
    this.attributes = attributes;
  }

  @Override
  public String toString() {
    return "ProductVariantImportDraft{id='" + id + "', sku='" + sku + "', prices='" + prices + "', images='" + images + "', attributes='" + attributes + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantImportDraft that = (ProductVariantImportDraft) o;
    return Objects.equals(id, that.id) &&
        Objects.equals(sku, that.sku) &&
        Objects.equals(prices, that.prices) &&
        Objects.equals(images, that.images) &&
        Objects.equals(attributes, that.attributes);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, sku, prices, images, attributes);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private Integer id;

    private String sku;

    private List<ProductPriceDataInput> prices = Collections.emptyList();

    private List<ImageInput> images = Collections.emptyList();

    private List<ProductAttributeInput> attributes = Collections.emptyList();

    public ProductVariantImportDraft build() {
      ProductVariantImportDraft result = new ProductVariantImportDraft();
      result.id = this.id;
      result.sku = this.sku;
      result.prices = this.prices;
      result.images = this.images;
      result.attributes = this.attributes;
      return result;
    }

    public Builder id(Integer id) {
      this.id = id;
      return this;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder prices(List<ProductPriceDataInput> prices) {
      this.prices = prices;
      return this;
    }

    public Builder images(List<ImageInput> images) {
      this.images = images;
      return this;
    }

    public Builder attributes(List<ProductAttributeInput> attributes) {
      this.attributes = attributes;
      return this;
    }
  }
}
