package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ProductVariantInput {
  private String sku;

  private String key;

  private List<ProductPriceDataInput> prices = Collections.emptyList();

  private List<ImageInput> images = Collections.emptyList();

  private List<ProductAttributeInput> attributes = Collections.emptyList();

  private List<AssetDraftInput> assets = Collections.emptyList();

  public ProductVariantInput() {
  }

  public ProductVariantInput(String sku, String key, List<ProductPriceDataInput> prices,
      List<ImageInput> images, List<ProductAttributeInput> attributes,
      List<AssetDraftInput> assets) {
    this.sku = sku;
    this.key = key;
    this.prices = prices;
    this.images = images;
    this.attributes = attributes;
    this.assets = assets;
  }

  public String getSku() {
    return sku;
  }

  public void setSku(String sku) {
    this.sku = sku;
  }

  public String getKey() {
    return key;
  }

  public void setKey(String key) {
    this.key = key;
  }

  public List<ProductPriceDataInput> getPrices() {
    return prices;
  }

  public void setPrices(List<ProductPriceDataInput> prices) {
    this.prices = prices;
  }

  public List<ImageInput> getImages() {
    return images;
  }

  public void setImages(List<ImageInput> images) {
    this.images = images;
  }

  public List<ProductAttributeInput> getAttributes() {
    return attributes;
  }

  public void setAttributes(List<ProductAttributeInput> attributes) {
    this.attributes = attributes;
  }

  public List<AssetDraftInput> getAssets() {
    return assets;
  }

  public void setAssets(List<AssetDraftInput> assets) {
    this.assets = assets;
  }

  @Override
  public String toString() {
    return "ProductVariantInput{sku='" + sku + "', key='" + key + "', prices='" + prices + "', images='" + images + "', attributes='" + attributes + "', assets='" + assets + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantInput that = (ProductVariantInput) o;
    return Objects.equals(sku, that.sku) &&
        Objects.equals(key, that.key) &&
        Objects.equals(prices, that.prices) &&
        Objects.equals(images, that.images) &&
        Objects.equals(attributes, that.attributes) &&
        Objects.equals(assets, that.assets);
  }

  @Override
  public int hashCode() {
    return Objects.hash(sku, key, prices, images, attributes, assets);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String sku;

    private String key;

    private List<ProductPriceDataInput> prices = Collections.emptyList();

    private List<ImageInput> images = Collections.emptyList();

    private List<ProductAttributeInput> attributes = Collections.emptyList();

    private List<AssetDraftInput> assets = Collections.emptyList();

    public ProductVariantInput build() {
      ProductVariantInput result = new ProductVariantInput();
      result.sku = this.sku;
      result.key = this.key;
      result.prices = this.prices;
      result.images = this.images;
      result.attributes = this.attributes;
      result.assets = this.assets;
      return result;
    }

    public Builder sku(String sku) {
      this.sku = sku;
      return this;
    }

    public Builder key(String key) {
      this.key = key;
      return this;
    }

    public Builder prices(List<ProductPriceDataInput> prices) {
      this.prices = prices;
      return this;
    }

    public Builder images(List<ImageInput> images) {
      this.images = images;
      return this;
    }

    public Builder attributes(List<ProductAttributeInput> attributes) {
      this.attributes = attributes;
      return this;
    }

    public Builder assets(List<AssetDraftInput> assets) {
      this.assets = assets;
      return this;
    }
  }
}
