package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.String;
import java.util.List;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "__typename"
)
@JsonSubTypes({
    @JsonSubTypes.Type(value = ProductVariantSelectionIncludeAllExcept.class, name = "ProductVariantSelectionIncludeAllExcept"),
    @JsonSubTypes.Type(value = ProductVariantSelectionIncludeOnly.class, name = "ProductVariantSelectionIncludeOnly")
})
public interface ProductVariantSelection {
  String getType();

  void setType(String type);

  List<String> getSkus();

  void setSkus(List<String> skus);
}
