package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

public class ProductVariantSelectionDraft {
  private List<String> includeOnly;

  private List<String> includeAllExcept;

  public ProductVariantSelectionDraft() {
  }

  public ProductVariantSelectionDraft(List<String> includeOnly, List<String> includeAllExcept) {
    this.includeOnly = includeOnly;
    this.includeAllExcept = includeAllExcept;
  }

  public List<String> getIncludeOnly() {
    return includeOnly;
  }

  public void setIncludeOnly(List<String> includeOnly) {
    this.includeOnly = includeOnly;
  }

  public List<String> getIncludeAllExcept() {
    return includeAllExcept;
  }

  public void setIncludeAllExcept(List<String> includeAllExcept) {
    this.includeAllExcept = includeAllExcept;
  }

  @Override
  public String toString() {
    return "ProductVariantSelectionDraft{includeOnly='" + includeOnly + "', includeAllExcept='" + includeAllExcept + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantSelectionDraft that = (ProductVariantSelectionDraft) o;
    return Objects.equals(includeOnly, that.includeOnly) &&
        Objects.equals(includeAllExcept, that.includeAllExcept);
  }

  @Override
  public int hashCode() {
    return Objects.hash(includeOnly, includeAllExcept);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private List<String> includeOnly;

    private List<String> includeAllExcept;

    public ProductVariantSelectionDraft build() {
      ProductVariantSelectionDraft result = new ProductVariantSelectionDraft();
      result.includeOnly = this.includeOnly;
      result.includeAllExcept = this.includeAllExcept;
      return result;
    }

    public Builder includeOnly(List<String> includeOnly) {
      this.includeOnly = includeOnly;
      return this;
    }

    public Builder includeAllExcept(List<String> includeAllExcept) {
      this.includeAllExcept = includeAllExcept;
      return this;
    }
  }
}
