package com.commercetools.graphql.api.types;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.Objects;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NONE
)
public class ProductVariantSelectionIncludeOnly implements com.commercetools.graphql.api.types.ProductVariantSelection {
  private String type;

  private List<String> skus;

  public ProductVariantSelectionIncludeOnly() {
  }

  public ProductVariantSelectionIncludeOnly(String type, List<String> skus) {
    this.type = type;
    this.skus = skus;
  }

  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public List<String> getSkus() {
    return skus;
  }

  public void setSkus(List<String> skus) {
    this.skus = skus;
  }

  @Override
  public String toString() {
    return "ProductVariantSelectionIncludeOnly{type='" + type + "', skus='" + skus + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProductVariantSelectionIncludeOnly that = (ProductVariantSelectionIncludeOnly) o;
    return Objects.equals(type, that.type) &&
        Objects.equals(skus, that.skus);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, skus);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private String type;

    private List<String> skus;

    public ProductVariantSelectionIncludeOnly build() {
      ProductVariantSelectionIncludeOnly result = new ProductVariantSelectionIncludeOnly();
      result.type = this.type;
      result.skus = this.skus;
      return result;
    }

    public Builder type(String type) {
      this.type = type;
      return this;
    }

    public Builder skus(List<String> skus) {
      this.skus = skus;
      return this;
    }
  }
}
