package com.commercetools.graphql.api.types;

import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;

public class ProjectSettingsUpdateAction {
  private ChangeProjectSettingsCartsConfiguration changeCartsConfiguration;

  private ChangeProjectSettingsCountries changeCountries;

  private ChangeProjectSettingsCountryTaxRateFallbackEnabled changeCountryTaxRateFallbackEnabled;

  private ChangeProjectSettingsCurrencies changeCurrencies;

  private ChangeProjectSettingsCustomerSearchStatus changeCustomerSearchStatus;

  private ChangeProjectSettingsLanguages changeLanguages;

  private ChangeProjectSettingsMessagesConfiguration changeMessagesConfiguration;

  private ChangeProjectSettingsMessagesEnabled changeMessagesEnabled;

  private ChangeProjectSettingsMyBusinessUnitStatusOnCreation changeMyBusinessUnitStatusOnCreation;

  private ChangeProjectSettingsName changeName;

  private ChangeProjectSettingsOrderSearchStatus changeOrderSearchStatus;

  private ChangeProjectSettingsShoppingListsConfiguration changeShoppingListsConfiguration;

  private SetProjectSettingsExternalOAuth setExternalOAuth;

  private SetProjectSettingsShippingRateInputType setShippingRateInputType;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation setMyBusinessUnitAssociateRoleOnCreation;

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  private ChangeProjectSettingsBusinessUnitSearchStatus changeBusinessUnitSearchStatus;

  private ChangeProjectSettingsProductSearchIndexingEnabled changeProductSearchIndexingEnabled;

  public ProjectSettingsUpdateAction() {
  }

  public ProjectSettingsUpdateAction(
      ChangeProjectSettingsCartsConfiguration changeCartsConfiguration,
      ChangeProjectSettingsCountries changeCountries,
      ChangeProjectSettingsCountryTaxRateFallbackEnabled changeCountryTaxRateFallbackEnabled,
      ChangeProjectSettingsCurrencies changeCurrencies,
      ChangeProjectSettingsCustomerSearchStatus changeCustomerSearchStatus,
      ChangeProjectSettingsLanguages changeLanguages,
      ChangeProjectSettingsMessagesConfiguration changeMessagesConfiguration,
      ChangeProjectSettingsMessagesEnabled changeMessagesEnabled,
      ChangeProjectSettingsMyBusinessUnitStatusOnCreation changeMyBusinessUnitStatusOnCreation,
      ChangeProjectSettingsName changeName,
      ChangeProjectSettingsOrderSearchStatus changeOrderSearchStatus,
      ChangeProjectSettingsShoppingListsConfiguration changeShoppingListsConfiguration,
      SetProjectSettingsExternalOAuth setExternalOAuth,
      SetProjectSettingsShippingRateInputType setShippingRateInputType,
      SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation setMyBusinessUnitAssociateRoleOnCreation,
      ChangeProjectSettingsBusinessUnitSearchStatus changeBusinessUnitSearchStatus,
      ChangeProjectSettingsProductSearchIndexingEnabled changeProductSearchIndexingEnabled) {
    this.changeCartsConfiguration = changeCartsConfiguration;
    this.changeCountries = changeCountries;
    this.changeCountryTaxRateFallbackEnabled = changeCountryTaxRateFallbackEnabled;
    this.changeCurrencies = changeCurrencies;
    this.changeCustomerSearchStatus = changeCustomerSearchStatus;
    this.changeLanguages = changeLanguages;
    this.changeMessagesConfiguration = changeMessagesConfiguration;
    this.changeMessagesEnabled = changeMessagesEnabled;
    this.changeMyBusinessUnitStatusOnCreation = changeMyBusinessUnitStatusOnCreation;
    this.changeName = changeName;
    this.changeOrderSearchStatus = changeOrderSearchStatus;
    this.changeShoppingListsConfiguration = changeShoppingListsConfiguration;
    this.setExternalOAuth = setExternalOAuth;
    this.setShippingRateInputType = setShippingRateInputType;
    this.setMyBusinessUnitAssociateRoleOnCreation = setMyBusinessUnitAssociateRoleOnCreation;
    this.changeBusinessUnitSearchStatus = changeBusinessUnitSearchStatus;
    this.changeProductSearchIndexingEnabled = changeProductSearchIndexingEnabled;
  }

  public ChangeProjectSettingsCartsConfiguration getChangeCartsConfiguration() {
    return changeCartsConfiguration;
  }

  public void setChangeCartsConfiguration(
      ChangeProjectSettingsCartsConfiguration changeCartsConfiguration) {
    this.changeCartsConfiguration = changeCartsConfiguration;
  }

  public ChangeProjectSettingsCountries getChangeCountries() {
    return changeCountries;
  }

  public void setChangeCountries(ChangeProjectSettingsCountries changeCountries) {
    this.changeCountries = changeCountries;
  }

  public ChangeProjectSettingsCountryTaxRateFallbackEnabled getChangeCountryTaxRateFallbackEnabled(
      ) {
    return changeCountryTaxRateFallbackEnabled;
  }

  public void setChangeCountryTaxRateFallbackEnabled(
      ChangeProjectSettingsCountryTaxRateFallbackEnabled changeCountryTaxRateFallbackEnabled) {
    this.changeCountryTaxRateFallbackEnabled = changeCountryTaxRateFallbackEnabled;
  }

  public ChangeProjectSettingsCurrencies getChangeCurrencies() {
    return changeCurrencies;
  }

  public void setChangeCurrencies(ChangeProjectSettingsCurrencies changeCurrencies) {
    this.changeCurrencies = changeCurrencies;
  }

  public ChangeProjectSettingsCustomerSearchStatus getChangeCustomerSearchStatus() {
    return changeCustomerSearchStatus;
  }

  public void setChangeCustomerSearchStatus(
      ChangeProjectSettingsCustomerSearchStatus changeCustomerSearchStatus) {
    this.changeCustomerSearchStatus = changeCustomerSearchStatus;
  }

  public ChangeProjectSettingsLanguages getChangeLanguages() {
    return changeLanguages;
  }

  public void setChangeLanguages(ChangeProjectSettingsLanguages changeLanguages) {
    this.changeLanguages = changeLanguages;
  }

  public ChangeProjectSettingsMessagesConfiguration getChangeMessagesConfiguration() {
    return changeMessagesConfiguration;
  }

  public void setChangeMessagesConfiguration(
      ChangeProjectSettingsMessagesConfiguration changeMessagesConfiguration) {
    this.changeMessagesConfiguration = changeMessagesConfiguration;
  }

  public ChangeProjectSettingsMessagesEnabled getChangeMessagesEnabled() {
    return changeMessagesEnabled;
  }

  public void setChangeMessagesEnabled(ChangeProjectSettingsMessagesEnabled changeMessagesEnabled) {
    this.changeMessagesEnabled = changeMessagesEnabled;
  }

  public ChangeProjectSettingsMyBusinessUnitStatusOnCreation getChangeMyBusinessUnitStatusOnCreation(
      ) {
    return changeMyBusinessUnitStatusOnCreation;
  }

  public void setChangeMyBusinessUnitStatusOnCreation(
      ChangeProjectSettingsMyBusinessUnitStatusOnCreation changeMyBusinessUnitStatusOnCreation) {
    this.changeMyBusinessUnitStatusOnCreation = changeMyBusinessUnitStatusOnCreation;
  }

  public ChangeProjectSettingsName getChangeName() {
    return changeName;
  }

  public void setChangeName(ChangeProjectSettingsName changeName) {
    this.changeName = changeName;
  }

  public ChangeProjectSettingsOrderSearchStatus getChangeOrderSearchStatus() {
    return changeOrderSearchStatus;
  }

  public void setChangeOrderSearchStatus(
      ChangeProjectSettingsOrderSearchStatus changeOrderSearchStatus) {
    this.changeOrderSearchStatus = changeOrderSearchStatus;
  }

  public ChangeProjectSettingsShoppingListsConfiguration getChangeShoppingListsConfiguration() {
    return changeShoppingListsConfiguration;
  }

  public void setChangeShoppingListsConfiguration(
      ChangeProjectSettingsShoppingListsConfiguration changeShoppingListsConfiguration) {
    this.changeShoppingListsConfiguration = changeShoppingListsConfiguration;
  }

  public SetProjectSettingsExternalOAuth getSetExternalOAuth() {
    return setExternalOAuth;
  }

  public void setSetExternalOAuth(SetProjectSettingsExternalOAuth setExternalOAuth) {
    this.setExternalOAuth = setExternalOAuth;
  }

  public SetProjectSettingsShippingRateInputType getSetShippingRateInputType() {
    return setShippingRateInputType;
  }

  public void setSetShippingRateInputType(
      SetProjectSettingsShippingRateInputType setShippingRateInputType) {
    this.setShippingRateInputType = setShippingRateInputType;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation getSetMyBusinessUnitAssociateRoleOnCreation(
      ) {
    return setMyBusinessUnitAssociateRoleOnCreation;
  }

  public void setSetMyBusinessUnitAssociateRoleOnCreation(
      SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation setMyBusinessUnitAssociateRoleOnCreation) {
    this.setMyBusinessUnitAssociateRoleOnCreation = setMyBusinessUnitAssociateRoleOnCreation;
  }

  /**
   * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
   */
  public ChangeProjectSettingsBusinessUnitSearchStatus getChangeBusinessUnitSearchStatus() {
    return changeBusinessUnitSearchStatus;
  }

  public void setChangeBusinessUnitSearchStatus(
      ChangeProjectSettingsBusinessUnitSearchStatus changeBusinessUnitSearchStatus) {
    this.changeBusinessUnitSearchStatus = changeBusinessUnitSearchStatus;
  }

  public ChangeProjectSettingsProductSearchIndexingEnabled getChangeProductSearchIndexingEnabled() {
    return changeProductSearchIndexingEnabled;
  }

  public void setChangeProductSearchIndexingEnabled(
      ChangeProjectSettingsProductSearchIndexingEnabled changeProductSearchIndexingEnabled) {
    this.changeProductSearchIndexingEnabled = changeProductSearchIndexingEnabled;
  }

  @Override
  public String toString() {
    return "ProjectSettingsUpdateAction{changeCartsConfiguration='" + changeCartsConfiguration + "', changeCountries='" + changeCountries + "', changeCountryTaxRateFallbackEnabled='" + changeCountryTaxRateFallbackEnabled + "', changeCurrencies='" + changeCurrencies + "', changeCustomerSearchStatus='" + changeCustomerSearchStatus + "', changeLanguages='" + changeLanguages + "', changeMessagesConfiguration='" + changeMessagesConfiguration + "', changeMessagesEnabled='" + changeMessagesEnabled + "', changeMyBusinessUnitStatusOnCreation='" + changeMyBusinessUnitStatusOnCreation + "', changeName='" + changeName + "', changeOrderSearchStatus='" + changeOrderSearchStatus + "', changeShoppingListsConfiguration='" + changeShoppingListsConfiguration + "', setExternalOAuth='" + setExternalOAuth + "', setShippingRateInputType='" + setShippingRateInputType + "', setMyBusinessUnitAssociateRoleOnCreation='" + setMyBusinessUnitAssociateRoleOnCreation + "', changeBusinessUnitSearchStatus='" + changeBusinessUnitSearchStatus + "', changeProductSearchIndexingEnabled='" + changeProductSearchIndexingEnabled + "'}";
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ProjectSettingsUpdateAction that = (ProjectSettingsUpdateAction) o;
    return Objects.equals(changeCartsConfiguration, that.changeCartsConfiguration) &&
        Objects.equals(changeCountries, that.changeCountries) &&
        Objects.equals(changeCountryTaxRateFallbackEnabled, that.changeCountryTaxRateFallbackEnabled) &&
        Objects.equals(changeCurrencies, that.changeCurrencies) &&
        Objects.equals(changeCustomerSearchStatus, that.changeCustomerSearchStatus) &&
        Objects.equals(changeLanguages, that.changeLanguages) &&
        Objects.equals(changeMessagesConfiguration, that.changeMessagesConfiguration) &&
        Objects.equals(changeMessagesEnabled, that.changeMessagesEnabled) &&
        Objects.equals(changeMyBusinessUnitStatusOnCreation, that.changeMyBusinessUnitStatusOnCreation) &&
        Objects.equals(changeName, that.changeName) &&
        Objects.equals(changeOrderSearchStatus, that.changeOrderSearchStatus) &&
        Objects.equals(changeShoppingListsConfiguration, that.changeShoppingListsConfiguration) &&
        Objects.equals(setExternalOAuth, that.setExternalOAuth) &&
        Objects.equals(setShippingRateInputType, that.setShippingRateInputType) &&
        Objects.equals(setMyBusinessUnitAssociateRoleOnCreation, that.setMyBusinessUnitAssociateRoleOnCreation) &&
        Objects.equals(changeBusinessUnitSearchStatus, that.changeBusinessUnitSearchStatus) &&
        Objects.equals(changeProductSearchIndexingEnabled, that.changeProductSearchIndexingEnabled);
  }

  @Override
  public int hashCode() {
    return Objects.hash(changeCartsConfiguration, changeCountries, changeCountryTaxRateFallbackEnabled, changeCurrencies, changeCustomerSearchStatus, changeLanguages, changeMessagesConfiguration, changeMessagesEnabled, changeMyBusinessUnitStatusOnCreation, changeName, changeOrderSearchStatus, changeShoppingListsConfiguration, setExternalOAuth, setShippingRateInputType, setMyBusinessUnitAssociateRoleOnCreation, changeBusinessUnitSearchStatus, changeProductSearchIndexingEnabled);
  }

  public static Builder newBuilder() {
    return new Builder();
  }

  public static class Builder {
    private ChangeProjectSettingsCartsConfiguration changeCartsConfiguration;

    private ChangeProjectSettingsCountries changeCountries;

    private ChangeProjectSettingsCountryTaxRateFallbackEnabled changeCountryTaxRateFallbackEnabled;

    private ChangeProjectSettingsCurrencies changeCurrencies;

    private ChangeProjectSettingsCustomerSearchStatus changeCustomerSearchStatus;

    private ChangeProjectSettingsLanguages changeLanguages;

    private ChangeProjectSettingsMessagesConfiguration changeMessagesConfiguration;

    private ChangeProjectSettingsMessagesEnabled changeMessagesEnabled;

    private ChangeProjectSettingsMyBusinessUnitStatusOnCreation changeMyBusinessUnitStatusOnCreation;

    private ChangeProjectSettingsName changeName;

    private ChangeProjectSettingsOrderSearchStatus changeOrderSearchStatus;

    private ChangeProjectSettingsShoppingListsConfiguration changeShoppingListsConfiguration;

    private SetProjectSettingsExternalOAuth setExternalOAuth;

    private SetProjectSettingsShippingRateInputType setShippingRateInputType;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation setMyBusinessUnitAssociateRoleOnCreation;

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    private ChangeProjectSettingsBusinessUnitSearchStatus changeBusinessUnitSearchStatus;

    private ChangeProjectSettingsProductSearchIndexingEnabled changeProductSearchIndexingEnabled;

    public ProjectSettingsUpdateAction build() {
      ProjectSettingsUpdateAction result = new ProjectSettingsUpdateAction();
      result.changeCartsConfiguration = this.changeCartsConfiguration;
      result.changeCountries = this.changeCountries;
      result.changeCountryTaxRateFallbackEnabled = this.changeCountryTaxRateFallbackEnabled;
      result.changeCurrencies = this.changeCurrencies;
      result.changeCustomerSearchStatus = this.changeCustomerSearchStatus;
      result.changeLanguages = this.changeLanguages;
      result.changeMessagesConfiguration = this.changeMessagesConfiguration;
      result.changeMessagesEnabled = this.changeMessagesEnabled;
      result.changeMyBusinessUnitStatusOnCreation = this.changeMyBusinessUnitStatusOnCreation;
      result.changeName = this.changeName;
      result.changeOrderSearchStatus = this.changeOrderSearchStatus;
      result.changeShoppingListsConfiguration = this.changeShoppingListsConfiguration;
      result.setExternalOAuth = this.setExternalOAuth;
      result.setShippingRateInputType = this.setShippingRateInputType;
      result.setMyBusinessUnitAssociateRoleOnCreation = this.setMyBusinessUnitAssociateRoleOnCreation;
      result.changeBusinessUnitSearchStatus = this.changeBusinessUnitSearchStatus;
      result.changeProductSearchIndexingEnabled = this.changeProductSearchIndexingEnabled;
      return result;
    }

    public Builder changeCartsConfiguration(
        ChangeProjectSettingsCartsConfiguration changeCartsConfiguration) {
      this.changeCartsConfiguration = changeCartsConfiguration;
      return this;
    }

    public Builder changeCountries(ChangeProjectSettingsCountries changeCountries) {
      this.changeCountries = changeCountries;
      return this;
    }

    public Builder changeCountryTaxRateFallbackEnabled(
        ChangeProjectSettingsCountryTaxRateFallbackEnabled changeCountryTaxRateFallbackEnabled) {
      this.changeCountryTaxRateFallbackEnabled = changeCountryTaxRateFallbackEnabled;
      return this;
    }

    public Builder changeCurrencies(ChangeProjectSettingsCurrencies changeCurrencies) {
      this.changeCurrencies = changeCurrencies;
      return this;
    }

    public Builder changeCustomerSearchStatus(
        ChangeProjectSettingsCustomerSearchStatus changeCustomerSearchStatus) {
      this.changeCustomerSearchStatus = changeCustomerSearchStatus;
      return this;
    }

    public Builder changeLanguages(ChangeProjectSettingsLanguages changeLanguages) {
      this.changeLanguages = changeLanguages;
      return this;
    }

    public Builder changeMessagesConfiguration(
        ChangeProjectSettingsMessagesConfiguration changeMessagesConfiguration) {
      this.changeMessagesConfiguration = changeMessagesConfiguration;
      return this;
    }

    public Builder changeMessagesEnabled(
        ChangeProjectSettingsMessagesEnabled changeMessagesEnabled) {
      this.changeMessagesEnabled = changeMessagesEnabled;
      return this;
    }

    public Builder changeMyBusinessUnitStatusOnCreation(
        ChangeProjectSettingsMyBusinessUnitStatusOnCreation changeMyBusinessUnitStatusOnCreation) {
      this.changeMyBusinessUnitStatusOnCreation = changeMyBusinessUnitStatusOnCreation;
      return this;
    }

    public Builder changeName(ChangeProjectSettingsName changeName) {
      this.changeName = changeName;
      return this;
    }

    public Builder changeOrderSearchStatus(
        ChangeProjectSettingsOrderSearchStatus changeOrderSearchStatus) {
      this.changeOrderSearchStatus = changeOrderSearchStatus;
      return this;
    }

    public Builder changeShoppingListsConfiguration(
        ChangeProjectSettingsShoppingListsConfiguration changeShoppingListsConfiguration) {
      this.changeShoppingListsConfiguration = changeShoppingListsConfiguration;
      return this;
    }

    public Builder setExternalOAuth(SetProjectSettingsExternalOAuth setExternalOAuth) {
      this.setExternalOAuth = setExternalOAuth;
      return this;
    }

    public Builder setShippingRateInputType(
        SetProjectSettingsShippingRateInputType setShippingRateInputType) {
      this.setShippingRateInputType = setShippingRateInputType;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder setMyBusinessUnitAssociateRoleOnCreation(
        SetProjectSettingsMyBusinessUnitAssociateRoleOnCreation setMyBusinessUnitAssociateRoleOnCreation) {
      this.setMyBusinessUnitAssociateRoleOnCreation = setMyBusinessUnitAssociateRoleOnCreation;
      return this;
    }

    /**
     * BETA: This feature can be subject to change and should be used carefully in production. https://docs.commercetools.com/api/contract#public-beta
     */
    public Builder changeBusinessUnitSearchStatus(
        ChangeProjectSettingsBusinessUnitSearchStatus changeBusinessUnitSearchStatus) {
      this.changeBusinessUnitSearchStatus = changeBusinessUnitSearchStatus;
      return this;
    }

    public Builder changeProductSearchIndexingEnabled(
        ChangeProjectSettingsProductSearchIndexingEnabled changeProductSearchIndexingEnabled) {
      this.changeProductSearchIndexingEnabled = changeProductSearchIndexingEnabled;
      return this;
    }
  }
}
